/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.server.UploadUriProvider;

public class UploadUriProviderTest {
    private static final String PARAM_PATH = "path";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_FILENAME = "fileName";

    @Test(expected=FileUploadException.class)
    public void requestEmpty() throws URISyntaxException, FileUploadException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        UploadUriProvider.getTargetLocation((HttpServletRequest)request);
    }

    @Test
    public void paramIsNotEncoded() throws URISyntaxException, FileUploadException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"project/hello & goodbye.txt").when((Object)request)).getParameter(PARAM_PATH);
        URI uri = UploadUriProvider.getTargetLocation((HttpServletRequest)request);
        Assert.assertEquals((Object)"project/hello+%26+goodbye.txt", (Object)uri.toString());
    }

    @Test
    public void paramIsEncoded() throws URISyntaxException, FileUploadException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"project/hello+%26+goodbye.txt").when((Object)request)).getParameter(PARAM_PATH);
        URI uri = UploadUriProvider.getTargetLocation((HttpServletRequest)request);
        Assert.assertEquals((Object)"project/hello+%26+goodbye.txt", (Object)uri.toString());
    }

    @Test
    public void fileNameIsNotEncoded() throws URISyntaxException, FileUploadException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"otherProject").when((Object)request)).getParameter(PARAM_FOLDER);
        ((HttpServletRequest)Mockito.doReturn((Object)"blaa & blaa.txt").when((Object)request)).getParameter(PARAM_FILENAME);
        URI uri = UploadUriProvider.getTargetLocation((HttpServletRequest)request);
        Assert.assertEquals((Object)"otherProject/blaa+%26+blaa.txt", (Object)uri.toString());
    }

    @Test
    public void fileNameIsEncoded() throws URISyntaxException, FileUploadException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"otherProject/subfolder").when((Object)request)).getParameter(PARAM_FOLDER);
        ((HttpServletRequest)Mockito.doReturn((Object)"do+%26+it.txt").when((Object)request)).getParameter(PARAM_FILENAME);
        URI uri = UploadUriProvider.getTargetLocation((HttpServletRequest)request);
        Assert.assertEquals((Object)"otherProject/subfolder/do+%26+it.txt", (Object)uri.toString());
    }
}

