/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;

@ApplicationScoped
public class ACLMigrationTool {
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private PermissionManager permissionManager;
    private AuthorizationPolicyStorage authorizationPolicyStorage;
    private Map<String, Group> groupMap = new HashMap<String, Group>();

    @Inject
    public ACLMigrationTool(OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, PermissionManager permissionManager, AuthorizationPolicyStorage authorizationPolicyStorage) {
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.permissionManager = permissionManager;
        this.authorizationPolicyStorage = authorizationPolicyStorage;
    }

    public void onDeploy(@Observes AuthorizationPolicyDeployedEvent event) {
        AuthorizationPolicy policy = event.getPolicy();
        this.migrateOrgUnits(policy);
        this.migrateRepositories(policy);
        this.authorizationPolicyStorage.savePolicy(policy);
    }

    private Group getGroup(String groupName) {
        Group group = this.groupMap.get(groupName);
        if (group == null) {
            group = new GroupImpl(groupName);
            this.groupMap.put(groupName, group);
        }
        return group;
    }

    public void migrateOrgUnits(AuthorizationPolicy policy) {
        Collection itemList = this.organizationalUnitService.getAllOrganizationalUnits();
        for (OrganizationalUnit organizationalUnit : itemList) {
            Permission permission = this.permissionManager.createPermission((Resource)organizationalUnit, OrganizationalUnitAction.READ, true);
            for (String groupName : organizationalUnit.getGroups()) {
                Group group = this.getGroup(groupName);
                PermissionCollection permissionCollection = policy.getPermissions(group);
                permissionCollection.add(new Permission[]{permission});
            }
        }
    }

    public void migrateRepositories(AuthorizationPolicy policy) {
        Collection itemList = this.repositoryService.getAllRepositoriesFromAllUserSpaces();
        for (Repository repository : itemList) {
            Permission permission = this.permissionManager.createPermission((Resource)repository, RepositoryAction.READ, true);
            for (String groupName : repository.getGroups()) {
                Group group = this.getGroup(groupName);
                PermissionCollection permissionCollection = policy.getPermissions(group);
                permissionCollection.add(new Permission[]{permission});
            }
        }
    }
}

