/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.archive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.archive.ZipWriter;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class Archiver {
    private Path originalPath;
    private ZipWriter zipWriter;
    private IOService ioService;

    public Archiver() {
    }

    @Inject
    public Archiver(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public void archive(ByteArrayOutputStream outputStream, String uri) throws IOException, URISyntaxException {
        this.init(outputStream, uri);
        this.zip();
    }

    private void zip() throws IOException {
        if (Files.isDirectory((Path)this.originalPath, (LinkOption[])new LinkOption[0])) {
            this.addPath((DirectoryStream<Path>)Files.newDirectoryStream((Path)this.originalPath));
        } else {
            this.addFile(this.originalPath);
        }
        this.zipWriter.close();
    }

    private void init(ByteArrayOutputStream outputStream, String uri) throws URISyntaxException {
        this.originalPath = this.ioService.get(new URI(uri));
        this.zipWriter = new ZipWriter(outputStream);
    }

    private void addPath(DirectoryStream<Path> directoryStream) throws IOException {
        for (Path subPath : directoryStream) {
            if (Files.isDirectory((Path)subPath, (LinkOption[])new LinkOption[0])) {
                this.addPath((DirectoryStream<Path>)Files.newDirectoryStream((Path)subPath));
                continue;
            }
            this.addFile(subPath);
        }
    }

    private void addFile(Path subPath) throws IOException {
        this.zipWriter.addFile(this.getZipEntry(subPath), this.ioService.newInputStream(subPath, new OpenOption[0]));
    }

    private ZipEntry getZipEntry(Path subPath) {
        return new ZipEntry(FileNameResolver.resolve(subPath.toUri().getPath(), this.originalPath.toUri().getPath()));
    }

    static class FileNameResolver {
        FileNameResolver() {
        }

        protected static String resolve(String subPath, String originalPath) {
            if ("/".equals(originalPath)) {
                return subPath.substring(originalPath.length());
            }
            String fileSubPath = subPath.substring(originalPath.length());
            if (fileSubPath.charAt(0) == '/') {
                fileSubPath = fileSubPath.substring(1);
            }
            return FileNameResolver.getBaseFolder(originalPath) + fileSubPath;
        }

        private static String getBaseFolder(String originalPath) {
            if (originalPath.contains("/")) {
                return originalPath.substring(originalPath.lastIndexOf("/") + 1) + "/";
            }
            return originalPath + "/";
        }
    }
}

