/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.guvnor.common.services.backend.migration.ACLMigrationTool;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.vfs.Path;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class ACLMigrationToolTest {
    @Mock
    AuthorizationPolicyStorage policyStorage;
    @Mock
    OrganizationalUnitService organizationalUnitService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    OrganizationalUnit orgUnit1;
    @Mock
    Repository repo1;
    @Mock
    Module module1;
    @Mock
    WorkspaceProject workspaceProject1;
    @Spy
    @InjectMocks
    ACLMigrationTool migrationTool;
    PermissionManager permissionManager;
    AuthorizationPolicy authorizationPolicy;

    @Before
    public void setUp() {
        this.permissionManager = new DefaultPermissionManager();
        this.authorizationPolicy = this.permissionManager.newAuthorizationPolicy().build();
        this.migrationTool = (ACLMigrationTool)Mockito.spy((Object)new ACLMigrationTool(this.organizationalUnitService, this.repositoryService, this.permissionManager, this.policyStorage));
        Path repo1root = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.organizationalUnitService.getAllOrganizationalUnits()).thenReturn(Collections.singleton(this.orgUnit1));
        Mockito.when((Object)this.repositoryService.getAllRepositoriesFromAllUserSpaces()).thenReturn(Collections.singleton(this.repo1));
        Mockito.when((Object)this.orgUnit1.getIdentifier()).thenReturn((Object)"orgUnit1");
        Mockito.when((Object)this.orgUnit1.getResourceType()).thenReturn((Object)OrganizationalUnit.RESOURCE_TYPE);
        Mockito.when((Object)this.orgUnit1.getGroups()).thenReturn(Collections.singleton("group1"));
        Mockito.when((Object)this.repo1.getIdentifier()).thenReturn((Object)"repo1");
        Branch master = new Branch("master", repo1root);
        Mockito.when((Object)this.repo1.getBranch("master")).thenReturn(Optional.of(master));
        Mockito.when((Object)this.repo1.getDefaultBranch()).thenReturn(Optional.of(master));
        Mockito.when((Object)this.repo1.getResourceType()).thenReturn((Object)Repository.RESOURCE_TYPE);
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add("group1");
        groupList.add("group2");
        Mockito.when((Object)this.repo1.getGroups()).thenReturn(groupList);
    }

    @Test
    public void migrationTest() {
        this.migrationTool.onDeploy(new AuthorizationPolicyDeployedEvent(this.authorizationPolicy));
        ((ACLMigrationTool)Mockito.verify((Object)this.migrationTool)).migrateOrgUnits(this.authorizationPolicy);
        ((ACLMigrationTool)Mockito.verify((Object)this.migrationTool)).migrateRepositories(this.authorizationPolicy);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.policyStorage)).savePolicy(this.authorizationPolicy);
        Assert.assertEquals((long)this.authorizationPolicy.getRoles().size(), (long)0L);
        Assert.assertEquals((long)this.authorizationPolicy.getGroups().size(), (long)2L);
        PermissionCollection pc1 = this.authorizationPolicy.getPermissions((Group)new GroupImpl("group1"));
        Assert.assertNotNull((Object)pc1);
        Assert.assertEquals((long)pc1.collection().size(), (long)2L);
        Permission p1 = pc1.get("orgunit.read.orgUnit1");
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((Object)p1.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        Permission p2 = pc1.get("repository.read.repo1");
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)p2.getResult(), (Object)AuthorizationResult.ACCESS_GRANTED);
        PermissionCollection pc2 = this.authorizationPolicy.getPermissions((Group)new GroupImpl("group2"));
        Assert.assertNotNull((Object)pc2);
        Assert.assertEquals((long)pc2.collection().size(), (long)1L);
    }
}

