/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.util;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class CommentedOptionFactoryImpl
implements CommentedOptionFactory {
    private static final String UNKNOWN_IDENTITY = "unknown";
    private SafeSessionInfo safeSessionInfo;

    public CommentedOptionFactoryImpl() {
    }

    @Inject
    public CommentedOptionFactoryImpl(SessionInfo safeSessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(safeSessionInfo);
    }

    public CommentedOption makeCommentedOption(String commitMessage) {
        new SafeSessionInfo(this.safeSessionInfo);
        return this.makeCommentedOption(commitMessage, this.safeSessionInfo.getIdentity(), this.safeSessionInfo);
    }

    public CommentedOption makeCommentedOption(String commitMessage, User identity, SessionInfo sessionInfo) {
        return new CommentedOption(new SafeSessionInfo(sessionInfo).getId(), this.getIdentityName(identity), null, commitMessage, new Date());
    }

    public CommentedOption makeCommentedOption(String sessionId, String commitMessage) {
        return new CommentedOption(sessionId, this.safeSessionInfo.getIdentity().getIdentifier(), null, commitMessage, new Date());
    }

    public String getSafeSessionId() {
        return this.safeSessionInfo.getId();
    }

    public String getSafeIdentityName() {
        return this.safeSessionInfo.getIdentity().getIdentifier();
    }

    protected String getIdentityName(User identity) {
        try {
            return identity.getIdentifier();
        }
        catch (Exception e) {
            return UNKNOWN_IDENTITY;
        }
    }
}

