/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.metadata.MetadataServiceImpl;
import org.guvnor.common.services.backend.metadata.OtherMetaAttributesMock;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={IOUtils.class})
public class MetadataServiceImplTest {
    private SimpleFileSystemProvider fileSystemProvider;
    @Mock
    private IOService ioService;
    @Mock
    private IOService configIOService;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private OtherMetaView otherMetaView;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    private Path path;
    private MetadataServerSideService service;

    @Before
    public void setUp() throws Exception {
        this.fileSystemProvider = new SimpleFileSystemProvider();
        this.fileSystemProvider.forceAsDefault();
        this.path = this.fileSystemProvider.getPath(this.getClass().getResource("myfile.file").toURI());
        this.service = new MetadataServiceImpl(this.ioService, this.configIOService, this.commentedOptionFactory, this.sessionInfo);
    }

    @Test
    public void testGetEmptyTagsNoOtherMetaView() {
        List tags = this.service.getTags(this.path);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)0L, (long)tags.size());
    }

    @Test
    public void testSaveMetaData() throws IOException {
        InputStream is = (InputStream)Mockito.spy((Object)new ByteArrayInputStream("hello".getBytes(StandardCharsets.UTF_8)));
        ((IOService)Mockito.doReturn((Object)is).when((Object)this.ioService)).newInputStream((Path)Mockito.any(), (OpenOption[])Mockito.any());
        CommentedOption comment = new CommentedOption("comment");
        ((CommentedOptionFactory)Mockito.doReturn((Object)comment).when((Object)this.commentedOptionFactory)).makeCommentedOption("comment");
        this.service.saveMetadata(Paths.convert((Path)this.path), new Metadata(), "comment");
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)Mockito.any(Path.class), (byte[])Mockito.any(byte[].class), Mockito.anyMap(), new OpenOption[]{(OpenOption)Mockito.eq((Object)comment)});
        ((InputStream)Mockito.verify((Object)is)).close();
    }

    @Test(expected=GenericPortableException.class)
    public void testSaveMetaDataException() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream("hello".getBytes(StandardCharsets.UTF_8));){
            ((IOService)Mockito.doReturn((Object)is).when((Object)this.ioService)).newInputStream((Path)Mockito.any(), (OpenOption[])Mockito.any());
            PowerMockito.mockStatic(IOUtils.class, (Class[])new Class[0]);
            BDDMockito.given((Object)IOUtils.toByteArray((InputStream)((InputStream)Mockito.any()))).willThrow(IOException.class);
            this.service.saveMetadata(Paths.convert((Path)this.path), new Metadata(), "comment");
        }
    }

    @Test
    public void testGetEmptyTags() {
        Mockito.when((Object)this.otherMetaView.readAttributes()).thenReturn((Object)new OtherMetaAttributesMock());
        Mockito.when((Object)((OtherMetaView)this.ioService.getFileAttributeView(this.path, OtherMetaView.class))).thenReturn((Object)this.otherMetaView);
        List tags = this.service.getTags(this.path);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)0L, (long)tags.size());
    }

    @Test
    public void testGetTags() {
        Mockito.when((Object)this.otherMetaView.readAttributes()).thenReturn((Object)new OtherMetaAttributesMock(){
            List<String> tags = new ArrayList<String>(){
                {
                    this.add("tag1");
                }
            };

            public List<String> tags() {
                return this.tags;
            }
        });
        Mockito.when((Object)((OtherMetaView)this.ioService.getFileAttributeView(this.path, OtherMetaView.class))).thenReturn((Object)this.otherMetaView);
        List tags = this.service.getTags(this.path);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)1L, (long)tags.size());
    }
}

