/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.test;

import java.util.ArrayList;
import java.util.Collections;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.backend.test.TestRunnerServiceImpl;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class TestRunnerServiceImplTest {
    @Mock
    private TestService testService1;
    @Mock
    private TestService testService2;
    @Mock
    private Event<TestResultMessage> defaultTestResultMessageEvent;
    @Captor
    private ArgumentCaptor<TestResultMessage> testResultMessageArgumentCaptor;
    private TestRunnerServiceImpl testRunnerService;

    @Before
    public void setUp() throws Exception {
        Instance services = (Instance)Mockito.mock(Instance.class);
        ArrayList<TestService> list = new ArrayList<TestService>();
        list.add(this.testService1);
        list.add(this.testService2);
        ((Instance)Mockito.doReturn(list.iterator()).when((Object)services)).iterator();
        this.testRunnerService = new TestRunnerServiceImpl(services, this.defaultTestResultMessageEvent);
    }

    @Test
    public void runAllTests() throws Exception {
        this.setUpTestService(this.testService1, 1, 200, 1);
        this.setUpTestService(this.testService2, 2, 300, 2);
        Path path = (Path)Mockito.mock(Path.class);
        this.testRunnerService.runAllTests("id", path);
        ((Event)Mockito.verify(this.defaultTestResultMessageEvent, (VerificationMode)Mockito.only())).fire((Object)((TestResultMessage)this.testResultMessageArgumentCaptor.capture()));
        TestResultMessage testResultMessage = (TestResultMessage)this.testResultMessageArgumentCaptor.getValue();
        Assert.assertEquals((Object)"id", (Object)testResultMessage.getIdentifier());
        Assert.assertEquals((long)3L, (long)testResultMessage.getRunCount());
        Assert.assertEquals((long)500L, (long)testResultMessage.getRunTime());
        Assert.assertEquals((long)3L, (long)testResultMessage.getFailures().size());
        ((TestService)Mockito.verify((Object)this.testService1)).runAllTests((String)ArgumentMatchers.eq((Object)"id"), (Path)ArgumentMatchers.eq((Object)path));
        ((TestService)Mockito.verify((Object)this.testService2)).runAllTests((String)ArgumentMatchers.eq((Object)"id"), (Path)ArgumentMatchers.eq((Object)path));
    }

    @Test
    public void runAllTestsCustomTestResultEvent() throws Exception {
        this.setUpTestService(this.testService1, 2, 500, 1);
        this.setUpTestService(this.testService2, 2, 300, 0);
        Path path = (Path)Mockito.mock(Path.class);
        Event event = (Event)Mockito.mock(Event.class);
        this.testRunnerService.runAllTests("id", path, event);
        ((Event)Mockito.verify((Object)event)).fire(this.testResultMessageArgumentCaptor.capture());
        TestResultMessage testResultMessage = (TestResultMessage)this.testResultMessageArgumentCaptor.getValue();
        Assert.assertEquals((Object)"id", (Object)testResultMessage.getIdentifier());
        Assert.assertEquals((long)4L, (long)testResultMessage.getRunCount());
        Assert.assertEquals((long)800L, (long)testResultMessage.getRunTime());
        Assert.assertEquals((long)1L, (long)testResultMessage.getFailures().size());
        ((TestService)Mockito.verify((Object)this.testService1)).runAllTests((String)ArgumentMatchers.eq((Object)"id"), (Path)ArgumentMatchers.eq((Object)path));
        ((TestService)Mockito.verify((Object)this.testService2)).runAllTests((String)ArgumentMatchers.eq((Object)"id"), (Path)ArgumentMatchers.eq((Object)path));
    }

    private void setUpTestService(TestService testService, int runCount, int runTime, int failureCount) {
        ((TestService)Mockito.doAnswer(invocationOnMock -> {
            ArrayList<Failure> failures = new ArrayList<Failure>();
            for (int i = 0; i < failureCount; ++i) {
                failures.add(new Failure());
            }
            return Collections.singletonList(new TestResultMessage((String)invocationOnMock.getArguments()[0], runCount, (long)runTime, failures));
        }).when((Object)testService)).runAllTests(ArgumentMatchers.anyString(), (Path)ArgumentMatchers.any());
    }
}

