/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.config;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.backend.config.AppConfigServiceImpl;
import org.guvnor.common.services.backend.preferences.ApplicationPreferencesLoader;
import org.guvnor.common.services.backend.preferences.SystemPropertiesInitializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.mocks.MockInstanceImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class AppConfigServiceImplTest {
    @Mock
    private ApplicationPreferencesLoader preferencesLoader;
    private Instance<ApplicationPreferencesLoader> preferencesLoaders;
    @Mock
    private SystemPropertiesInitializer systemPropertiesInitializer;
    private Instance<SystemPropertiesInitializer> systemPropertiesInitializers;
    private AppConfigServiceImpl appConfigService;

    @Before
    public void setup() {
        this.preferencesLoaders = new MockInstanceImpl((Object[])new ApplicationPreferencesLoader[]{this.preferencesLoader});
        this.systemPropertiesInitializers = new MockInstanceImpl((Object[])new SystemPropertiesInitializer[]{this.systemPropertiesInitializer});
        this.appConfigService = new AppConfigServiceImpl(this.preferencesLoaders, this.systemPropertiesInitializers);
    }

    @Test
    public void systemPropertiesHavePriorityOnPreferencesLoaders() {
        HashMap<String, String> loaderProperties = new HashMap<String, String>();
        loaderProperties.put("property1", "loaderProperty1");
        loaderProperties.put("property2", "loaderProperty2");
        ((ApplicationPreferencesLoader)Mockito.doReturn(loaderProperties).when((Object)this.preferencesLoader)).load();
        System.setProperty("property1", "systemProperty1");
        System.setProperty("property3", "systemProperty3");
        Map preferences = this.appConfigService.loadPreferences();
        Assert.assertEquals((long)2L, (long)preferences.size());
        Assert.assertEquals((Object)"systemProperty1", preferences.get("property1"));
        Assert.assertEquals((Object)"loaderProperty2", preferences.get("property2"));
        ((SystemPropertiesInitializer)Mockito.verify((Object)this.systemPropertiesInitializer)).setSystemProperties(preferences);
    }
}

