/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.uberfire.ext.security.server.SecureHeadersConfig;

public class SecureHeadersFilter
implements Filter {
    public static final String LOCATION = "Location";
    public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
    public static final String X_FRAME_OPTIONS = "X-FRAME-OPTIONS";
    public static final String X_XSS_OPTIONS = "X-XSS-Protection";
    private static SecureHeadersConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        config = new SecureHeadersConfig(filterConfig);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        SecureHeadersFilter.applyHeaders((ServletRequest)request, response);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static void applyHeaders(ServletRequest request, HttpServletResponse response) {
        if (config != null) {
            SecureHeadersFilter.addLocation(response);
            SecureHeadersFilter.addFrameOptions(response);
            SecureHeadersFilter.addXSSOptions(response);
            if (request.getScheme().equals("https")) {
                SecureHeadersFilter.addStrictTransportSecurity(response);
            }
        }
    }

    private static void addStrictTransportSecurity(HttpServletResponse response) {
        if (config.hasMaxAge() && SecureHeadersFilter.empty(response.getHeader(STRICT_TRANSPORT_SECURITY))) {
            response.addHeader(STRICT_TRANSPORT_SECURITY, config.getMaxAge());
        }
    }

    private static void addFrameOptions(HttpServletResponse response) {
        if (config.hasFrameOptions() && SecureHeadersFilter.empty(response.getHeader(X_FRAME_OPTIONS))) {
            response.addHeader(X_FRAME_OPTIONS, config.getFrameOptions());
        }
    }

    private static void addLocation(HttpServletResponse response) {
        if (config.hasLocation() && SecureHeadersFilter.empty(response.getHeader(LOCATION))) {
            response.addHeader(LOCATION, config.getLocation());
            response.setStatus(301);
        }
    }

    private static void addXSSOptions(HttpServletResponse response) {
        if (config.hasXSSOptions() && SecureHeadersFilter.empty(response.getHeader(X_XSS_OPTIONS))) {
            response.addHeader(X_XSS_OPTIONS, config.getXssOptions());
        }
    }

    private static boolean empty(String content) {
        return content == null || content.trim().isEmpty();
    }
}

