/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.relations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.client.resources.i18n.Constants;
import org.ext.uberfire.social.activities.client.user.SocialUserImageProvider;
import org.ext.uberfire.social.activities.client.widgets.utils.FollowButton;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserImageRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialUserRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialUserServiceAPI;
import org.ext.uberfire.social.activities.utils.SocialUserNameComparator;
import org.gwtbootstrap3.client.ui.Badge;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ListGroup;
import org.gwtbootstrap3.client.ui.ListGroupItem;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.mvp.Command;

@Dependent
public class SocialRelationsWidget
extends Composite {
    static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    private final Constants constants = Constants.INSTANCE;
    @UiField
    Heading title;
    @UiField
    ListGroup allfollowing;
    @UiField
    ListGroup allfollowers;
    @UiField
    ListGroup allusers;
    @UiField
    Badge followingBadge;
    @UiField
    Badge followersBadge;
    @UiField
    Badge allusersBadge;
    @Inject
    private User loggedUser;
    private SocialUser socialLoggedUser;
    @Inject
    private SocialUserImageProvider imageProvider;

    @PostConstruct
    public void setup() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.updateWidget();
    }

    public void updateWidget() {
        ((SocialUserRepositoryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<SocialUser>(){

            public void callback(SocialUser user) {
                SocialRelationsWidget.this.socialLoggedUser = user;
                SocialRelationsWidget.this.title.setText(SocialRelationsWidget.this.constants.SocialUser() + ": " + SocialRelationsWidget.this.socialLoggedUser.getName());
                SocialRelationsWidget.this.printAllUsers();
            }
        }, SocialUserRepositoryAPI.class)).findSocialUser(this.loggedUser.getIdentifier());
    }

    private void printAllFollowers(List<SocialUser> users) {
        this.allfollowers.clear();
        this.followersBadge.setText(String.valueOf(this.socialLoggedUser.getFollowersName().size()));
        if (this.socialLoggedUser.getFollowersName().isEmpty()) {
            ListGroupItem user = new ListGroupItem();
            user.setText(this.constants.CurrentlyNotFollowedByAnyUser());
            this.allfollowers.add((Widget)user);
        } else {
            for (SocialUser follower : users) {
                if (!this.socialLoggedUser.getFollowersName().contains(follower.getUserName())) continue;
                this.allfollowers.add((Widget)this.createUserItem(follower, false));
            }
        }
    }

    private void printAllFollowing(List<SocialUser> users) {
        this.allfollowing.clear();
        this.followingBadge.setText(String.valueOf(this.socialLoggedUser.getFollowingName().size()));
        if (this.socialLoggedUser.getFollowingName().isEmpty()) {
            ListGroupItem user = new ListGroupItem();
            user.setText(this.constants.CurrentlyNotFollowingAnyUser());
            this.allfollowing.add((Widget)user);
        } else {
            for (SocialUser following : users) {
                if (!this.socialLoggedUser.getFollowingName().contains(following.getUserName())) continue;
                this.allfollowing.add((Widget)this.createUserItem(following, true));
            }
        }
    }

    private void printAllUsers() {
        ((SocialUserRepositoryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<List<SocialUser>>(){

            public void callback(List<SocialUser> users) {
                SocialRelationsWidget.this.allusers.clear();
                SocialRelationsWidget.this.allusersBadge.setText(String.valueOf(users.size()));
                Collections.sort(users, new SocialUserNameComparator());
                for (SocialUser socialUser : users) {
                    SocialRelationsWidget.this.allusers.add((Widget)SocialRelationsWidget.this.createUserItem(socialUser, socialUser.getFollowersName().contains(SocialRelationsWidget.this.socialLoggedUser.getUserName())));
                }
                SocialRelationsWidget.this.printAllFollowing(users);
                SocialRelationsWidget.this.printAllFollowers(users);
            }
        }, SocialUserRepositoryAPI.class)).findAllUsers();
    }

    private ListGroupItem createUserItem(SocialUser socialUser, boolean follow) {
        ListGroupItem user = new ListGroupItem();
        Image userImage = this.imageProvider.getImageForSocialUser(socialUser, SocialUserImageRepositoryAPI.ImageSize.SMALL);
        userImage.addStyleName("img-circle");
        userImage.addStyleName("pull-left");
        user.getWidget(0).getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
        user.add((Widget)userImage);
        user.setText(socialUser.getName());
        if (!socialUser.getUserName().equals(this.socialLoggedUser.getUserName())) {
            user.add((Widget)this.createFollowButton(socialUser, follow));
        }
        return user;
    }

    private Button createFollowButton(SocialUser socialUser, final boolean follow) {
        RemoteCallback<SocialUser> callback = new RemoteCallback<SocialUser>(){

            public void callback(SocialUser socialUser) {
                SocialRelationsWidget.this.updateWidget();
            }
        };
        FollowButton.FollowType followType = follow ? FollowButton.FollowType.UNFOLLOW : FollowButton.FollowType.FOLLOW;
        FollowButton followButton = new FollowButton(followType, new Command((RemoteCallback)callback, socialUser){
            final /* synthetic */ RemoteCallback val$callback;
            final /* synthetic */ SocialUser val$socialUser;
            {
                this.val$callback = remoteCallback;
                this.val$socialUser = socialUser;
            }

            public void execute() {
                if (follow) {
                    ((SocialUserServiceAPI)MessageBuilder.createCall((RemoteCallback)this.val$callback, SocialUserServiceAPI.class)).userUnfollowAnotherUser(SocialRelationsWidget.this.socialLoggedUser.getUserName(), this.val$socialUser.getUserName());
                } else {
                    ((SocialUserServiceAPI)MessageBuilder.createCall((RemoteCallback)this.val$callback, SocialUserServiceAPI.class)).userFollowAnotherUser(SocialRelationsWidget.this.socialLoggedUser.getUserName(), this.val$socialUser.getUserName());
                }
            }
        });
        followButton.addStyleName("pull-right");
        return followButton;
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SocialRelationsWidget> {
    }
}

