/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.item.model;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ext.uberfire.social.activities.client.widgets.item.model.LinkCommandParams;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.SocialTimelineWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.timeline.simple.model.SimpleSocialTimelineWidgetModel;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.mvp.ParameterizedCommand;

public class SimpleItemWidgetModel {
    private Date timestamp;
    private String linkText;
    private SocialUser socialUser;
    private String description;
    private PlaceManager placeManager;
    private Path linkPath;
    private SocialActivitiesEvent.LINK_TYPE linkType = SocialActivitiesEvent.LINK_TYPE.VFS;
    private String linkURI;
    private String itemDescription;
    private String title;
    private boolean withFileIcon;
    private String eventType;
    private List<ClientResourceType> resourceTypes;
    private ParameterizedCommand<LinkCommandParams> linkCommand;
    private Map<String, String> linkParams = new HashMap<String, String>();

    public SimpleItemWidgetModel(SimpleSocialTimelineWidgetModel model, String eventType, Date timestamp, String linkText, String linkURI, SocialActivitiesEvent.LINK_TYPE linkType, String itemDescription, SocialUser socialUser) {
        this.socialUser = socialUser;
        this.resourceTypes = model.getResourceTypes();
        this.placeManager = model.getPlaceManager();
        this.eventType = eventType;
        this.timestamp = timestamp;
        this.linkText = linkText;
        this.linkURI = linkURI;
        this.linkType = linkType;
        this.itemDescription = itemDescription;
    }

    public SimpleItemWidgetModel(String eventType, Date timestamp, String description, String itemDescription, SocialUser socialUser) {
        this.socialUser = socialUser;
        this.eventType = eventType;
        this.timestamp = timestamp;
        this.description = description;
        this.itemDescription = itemDescription;
    }

    public SimpleItemWidgetModel(SocialTimelineWidgetModel model, String eventType, Date timestamp, String linkText, String linkURI, SocialActivitiesEvent.LINK_TYPE linkType, String description, String itemDescription, SocialUser socialUser) {
        this.socialUser = socialUser;
        this.placeManager = model.getPlaceManager();
        this.eventType = eventType;
        this.timestamp = timestamp;
        this.linkText = linkText;
        this.linkURI = linkURI;
        this.linkType = linkType;
        this.description = description;
        this.itemDescription = itemDescription;
    }

    public SimpleItemWidgetModel(SocialTimelineWidgetModel model, String eventType, Date timestamp, String description, String itemDescription) {
        this.socialUser = model.getSocialUser();
        this.eventType = eventType;
        this.timestamp = timestamp;
        this.description = description;
        this.itemDescription = itemDescription;
    }

    public boolean shouldIPrintIcon() {
        return this.resourceTypes != null && this.getLinkText() != null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLinkText() {
        return this.cleanLinkText(this.linkText);
    }

    private String cleanLinkText(String linkText) {
        if (this.hasExtension(linkText)) {
            return this.removeExtension(linkText);
        }
        return linkText;
    }

    private String removeExtension(String linkText) {
        return linkText != null ? linkText.substring(0, linkText.indexOf(".")) : linkText;
    }

    private boolean hasExtension(String linkText) {
        return linkText != null && linkText.indexOf(46) > 0;
    }

    public SocialUser getSocialUser() {
        return this.socialUser;
    }

    public PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    public Path getLinkPath() {
        return this.linkPath;
    }

    public String getLinkURI() {
        return this.linkURI;
    }

    public SocialActivitiesEvent.LINK_TYPE getLinkType() {
        return this.linkType;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ClientResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    public String getEventType() {
        return this.eventType;
    }

    public boolean isVFSLink() {
        return this.linkType == SocialActivitiesEvent.LINK_TYPE.VFS;
    }

    public SimpleItemWidgetModel withLinkCommand(ParameterizedCommand<LinkCommandParams> linkCommand) {
        this.linkCommand = linkCommand;
        return this;
    }

    public SimpleItemWidgetModel withLinkPath(Path linkPath) {
        this.linkPath = linkPath;
        return this;
    }

    public SimpleItemWidgetModel withLinkParams(Map<String, String> linkParams) {
        if (linkParams != null) {
            this.linkParams.putAll(linkParams);
        }
        return this;
    }

    public ParameterizedCommand<LinkCommandParams> getLinkCommand() {
        if (this.linkCommand == null) {
            return new ParameterizedCommand<LinkCommandParams>(){

                public void execute(LinkCommandParams parameters) {
                }
            };
        }
        return this.linkCommand;
    }

    public Map<String, String> getLinkParams() {
        return this.linkParams;
    }
}

