/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.gravatar;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;
import org.ext.uberfire.social.activities.client.AppResource;
import org.ext.uberfire.social.activities.client.gravatar.GravatarImage;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserImageRepositoryAPI;

public class GravatarBuilder {
    public static Image generate(SocialUser socialUser, SocialUserImageRepositoryAPI.ImageSize imageSize) {
        if (socialUser.getEmail().isEmpty()) {
            return GravatarBuilder.generateDefaultImage(imageSize);
        }
        return GravatarBuilder.generateGravatarImage(socialUser, imageSize);
    }

    private static Image generateGravatarImage(SocialUser socialUser, SocialUserImageRepositoryAPI.ImageSize imageSize) {
        Image gravatarImage = imageSize == SocialUserImageRepositoryAPI.ImageSize.MICRO ? new Image(new GravatarImage(socialUser.getEmail(), 15).getUrl()) : (imageSize == SocialUserImageRepositoryAPI.ImageSize.SMALL ? new Image(new GravatarImage(socialUser.getEmail(), 30).getUrl()) : new Image(new GravatarImage(socialUser.getEmail(), 200).getUrl()));
        return gravatarImage;
    }

    private static Image generateDefaultImage(SocialUserImageRepositoryAPI.ImageSize size) {
        Image userImage;
        if (size == SocialUserImageRepositoryAPI.ImageSize.MICRO) {
            ImageResource imageResource = AppResource.INSTANCE.images().genericAvatar15px();
            userImage = new Image(imageResource);
        } else if (size == SocialUserImageRepositoryAPI.ImageSize.SMALL) {
            ImageResource imageResource = AppResource.INSTANCE.images().genericAvatar30px();
            userImage = new Image(imageResource);
        } else {
            ImageResource imageResource = AppResource.INSTANCE.images().genericAvatar();
            Image userImage2 = new Image(imageResource);
            return userImage2;
        }
        return userImage;
    }
}

