/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.item;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.ext.uberfire.social.activities.client.user.SocialUserImageProvider;
import org.ext.uberfire.social.activities.client.widgets.item.bundle.SocialBundleHelper;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.UpdateItem;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserImageRepositoryAPI;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ImageAnchor;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.ioc.client.container.IOC;

public class CommentRowWidget
extends Composite {
    private static final DateTimeFormat FORMATTER = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm:ss");
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    FlowPanel left;
    @UiField
    Paragraph desc;
    @UiField
    Heading heading;
    SocialUserImageProvider imageProvider = this.getSocialUserImageProvider();

    SocialUserImageProvider getSocialUserImageProvider() {
        return (SocialUserImageProvider)IOC.getBeanManager().lookupBean(SocialUserImageProvider.class, new Annotation[0]).getInstance();
    }

    public void init(UpdateItem model) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.createItem(model);
    }

    public void createItem(UpdateItem updateItem) {
        this.createThumbNail(updateItem);
        this.createAdditionalInfo(updateItem.getEvent());
        this.createUserInfo(updateItem.getEvent().getSocialUser());
    }

    private void createUserInfo(SocialUser socialUser) {
        this.heading.setText(socialUser.getName());
    }

    private void createAdditionalInfo(SocialActivitiesEvent event) {
        StringBuilder comment = new StringBuilder();
        comment.append(SocialBundleHelper.getItemDescription(event.getAdicionalInfos()));
        comment.append(" ");
        comment.append(FORMATTER.format(event.getTimestamp()));
        comment.append(" ");
        if (event.getDescription() != null && !event.getDescription().isEmpty()) {
            comment.append("\"" + event.getDescription() + "\"");
        }
        this.desc.add((Widget)new Text(comment.toString()));
    }

    void createThumbNail(final UpdateItem updateItem) {
        final SocialUser socialUser = updateItem.getEvent().getSocialUser();
        Image userImage = this.imageProvider.getImageForSocialUser(socialUser, SocialUserImageRepositoryAPI.ImageSize.SMALL);
        ImageAnchor newImage = (ImageAnchor)GWT.create(ImageAnchor.class);
        newImage.setUrl(userImage.getUrl());
        newImage.setAsMediaObject(true);
        newImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                updateItem.getUserClickCommand().execute((Object)socialUser.getUserName());
            }
        });
        this.left.add((Widget)newImage);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, CommentRowWidget> {
    }
}

