/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

public class TempFiles {
    private ArrayList<File> files = new ArrayList();

    public File createTempFile(String fullName) throws IOException {
        Iterator<String> iterator = Arrays.asList(fullName.split("/")).iterator();
        File previousFolder = null;
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (iterator.hasNext()) {
                previousFolder = this.createFolder(previousFolder, next);
                continue;
            }
            return this.createFile(previousFolder, next);
        }
        return null;
    }

    private File createFolder(File previousFolder, String next) throws IOException {
        if (previousFolder == null) {
            return this.createTempDirectory(next);
        }
        return this.createTempDirectory(next, previousFolder);
    }

    private File createFile(File previousFolder, String next) throws IOException {
        String suffix = this.getSuffix(next);
        String prefix = this.getPrefix(next);
        if (previousFolder == null) {
            File tempFile = File.createTempFile(prefix, suffix);
            this.files.add(tempFile);
            return tempFile;
        }
        File tempFile = File.createTempFile(prefix, suffix, previousFolder);
        this.files.add(tempFile);
        return tempFile;
    }

    public File createTempDirectory(String name) throws IOException {
        File temp = File.createTempFile(name, Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        this.files.add(temp);
        return temp;
    }

    private File createTempDirectory(String name, File file) throws IOException {
        File temp = File.createTempFile(name, Long.toString(System.nanoTime()), file);
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        this.files.add(temp);
        return temp;
    }

    private String getSuffix(String next) {
        int index = next.lastIndexOf(46);
        if (index >= 0) {
            return next.substring(0, index);
        }
        return next;
    }

    private String getPrefix(String next) {
        int index = next.lastIndexOf(46);
        if (index >= 0) {
            return next.substring(index);
        }
        return next;
    }

    public void deleteFiles() {
        for (File tempFile : this.files) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }
}

