/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.test;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.test.TempFiles;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class TestTempFileSystem {
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    Paths paths;
    private final TempFiles tempFiles;
    private final HashMap<org.uberfire.backend.vfs.Path, File> pathToFile = new HashMap();

    public TestTempFileSystem() throws Exception {
        this.tempFiles = new TempFiles();
    }

    public org.uberfire.backend.vfs.Path createTempFile(String fullFileName) throws IOException {
        File file = this.tempFiles.createTempFile(fullFileName);
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.ioService.get(file.toURI()));
        this.pathToFile.put(path, file);
        return path;
    }

    public org.uberfire.backend.vfs.Path createTempDirectory(String fullDirectoryName) throws IOException {
        File file = this.tempFiles.createTempDirectory(fullDirectoryName);
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.ioService.get(file.toURI()));
        this.pathToFile.put(path, file);
        return path;
    }

    public void deleteFile(org.uberfire.backend.vfs.Path path) {
        this.getFile(path).delete();
    }

    public File getFile(org.uberfire.backend.vfs.Path path) {
        return this.pathToFile.get(path);
    }

    public void tearDown() {
        this.tempFiles.deleteFiles();
    }
}

