/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.client.screens.splash;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import com.google.gwt.user.client.ui.InlineLabel;

import org.jboss.errai.ioc.client.api.ActivatedBy;

import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.AbstractSplashScreenActivity;
import org.uberfire.client.workbench.widgets.splash.SplashView;
import javax.inject.Named;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.SplashScreenFilter;
import org.uberfire.client.mvp.IsSplashScreen;

import com.google.gwt.user.client.ui.IsWidget;

@ApplicationScoped
@Generated("org.uberfire.annotations.processors.WorkbenchSplashScreenProcessor")
@Named("fileExplorer.splash")
@IsSplashScreen
@ActivatedBy(org.uberfire.client.screens.splash.NoSplashQueryParamActivator.class)
/*
 * WARNING! This class is generated. Do not modify.
 */
public class FileExplorerSplashScreenActivity extends AbstractSplashScreenActivity {

    private static final Collection<String> ROLES = Collections.emptyList();

    private static final Collection<String> TRAITS = Collections.emptyList();

    @Inject
    private FileExplorerSplashScreen realPresenter;

    @Inject
    //Constructor injection for testing
    public FileExplorerSplashScreenActivity( final PlaceManager placeManager, final SplashView view ) {
        super( placeManager, view );
    }

    @Override
    public String getTitle() {
        return realPresenter.getTitle();
    }

    @Override
    public IsWidget getWidget() {
        return realPresenter.getView();
    }

    @Override
    public Integer getBodyHeight() {
        return realPresenter.getBodySize();
    }

    @Override
    public SplashScreenFilter getFilter() {
        return realPresenter.getFilter();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Collection<String> getRoles() {
        return ROLES;
    }

    @Override
    public Collection<String> getTraits() {
        return TRAITS;
    }

    @Override
    public String getSignatureId() {
        return "org.uberfire.client.screens.splash.FileExplorerSplashScreenActivity";
    }

    @Override
    public String getIdentifier() {
        return "fileExplorer.splash";
    }

}
