/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.client.experimental.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Generated;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import javax.inject.Named;
import org.uberfire.client.workbench.annotations.AssociatedResources;
import org.uberfire.client.workbench.annotations.Priority;
import org.uberfire.client.mvp.AbstractWorkbenchEditorActivity;
import org.uberfire.client.mvp.PlaceManager;

import org.uberfire.mvp.PlaceRequest;

import org.uberfire.workbench.model.menu.Menus;

import org.uberfire.backend.vfs.ObservablePath;

import com.google.gwt.user.client.ui.IsWidget;

@Dependent
@Generated("org.uberfire.annotations.processors.WorkbenchEditorProcessor")
@Named("ExperimentalAsset")
@AssociatedResources({
    org.uberfire.client.experimental.editor.ExperimentalAssetResourceType.class
})

@Priority(0)
/*
 * WARNING! This class is generated. Do not modify.
 */
public class ExperimentalAssetEditorActivity extends AbstractWorkbenchEditorActivity {

    @Inject
    private ExperimentalAssetEditor realPresenter;

    @Inject
    //Constructor injection for testing
    public ExperimentalAssetEditorActivity(final PlaceManager placeManager) {
        super( placeManager );
    }

    @Override
    public void onStartup(final ObservablePath path,
                        final PlaceRequest place) {
        super.onStartup( path, place );
        realPresenter.onStartup( path, place );
    }

    @Override
    public IsWidget getTitleDecoration() {
        return realPresenter.getTitle();
    }

    @Override
    public String getTitle() {
        return realPresenter.getTitleText();
    }

    @Override
    public IsWidget getWidget() {
        return realPresenter.getView();
    }

    @Override
    public void getMenus(final Consumer<Menus> menusConsumer) {
        realPresenter.getMenus(menusConsumer);
    }

    @Override
    public String getIdentifier() {
        return "ExperimentalAsset";
    }
}
