/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.table.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.uberfire.ext.widgets.table.client.ColumnChangedHandler;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.ext.widgets.table.client.resources.UFTableResources;
import org.uberfire.ext.widgets.table.client.resources.i18n.CommonConstants;

public class UberfireColumnPicker<T> {
    protected final DataGrid<T> dataGrid;
    protected final List<ColumnMeta<T>> columnMetaList = new ArrayList<ColumnMeta<T>>();
    protected final PopupPanel popup = (PopupPanel)GWT.create(PopupPanel.class);
    protected List<ColumnChangedHandler> columnChangedHandler = new ArrayList<ColumnChangedHandler>();

    protected DataGrid<T> getDataGrid() {
        return this.dataGrid;
    }

    public UberfireColumnPicker(DataGrid<T> dataGrid) {
        this.dataGrid = dataGrid;
        this.setupPopup();
    }

    private void setupPopup() {
        this.popup.setAutoHideEnabled(true);
        this.popup.setAutoHideOnHistoryEventsEnabled(true);
    }

    public void addColumnChangedHandler(ColumnChangedHandler handler) {
        this.columnChangedHandler.add(handler);
    }

    public Collection<ColumnMeta<T>> getColumnMetaList() {
        return this.columnMetaList;
    }

    protected String getColumnStoreName(ColumnMeta columnMeta) {
        if (columnMeta != null) {
            String colStoreName;
            if (columnMeta.getColumn() != null && (colStoreName = columnMeta.getColumn().getDataStoreName()) != null && !colStoreName.isEmpty()) {
                return colStoreName;
            }
            return columnMeta.getCaption();
        }
        return "";
    }

    public void columnMoved(int visibleFromIndex, int visibleBeforeIndex) {
        int visibleColumnFromIndex = 0;
        ColumnMeta<T> columnMetaToMove = null;
        for (int i = 0; i < this.columnMetaList.size(); ++i) {
            ColumnMeta<T> columnMeta = this.columnMetaList.get(i);
            if (!columnMeta.isVisible()) continue;
            if (visibleFromIndex == visibleColumnFromIndex) {
                columnMetaToMove = columnMeta;
                break;
            }
            ++visibleColumnFromIndex;
        }
        if (columnMetaToMove == null) {
            return;
        }
        this.columnMetaList.remove(columnMetaToMove);
        boolean columnInserted = false;
        int visibleColumnBeforeIndex = 0;
        for (int i = 0; i < this.columnMetaList.size(); ++i) {
            ColumnMeta<T> columnMeta = this.columnMetaList.get(i);
            if (!columnMeta.isVisible()) continue;
            if (visibleBeforeIndex == visibleColumnBeforeIndex) {
                this.columnMetaList.add(i, columnMetaToMove);
                columnInserted = true;
                break;
            }
            ++visibleColumnBeforeIndex;
        }
        if (!columnInserted) {
            this.columnMetaList.add(columnMetaToMove);
        }
    }

    protected int getVisibleColumnIndex(ColumnMeta<T> columnMeta) {
        int index = 0;
        for (ColumnMeta<T> cm : this.columnMetaList) {
            if (cm.equals(columnMeta)) {
                return index;
            }
            if (!cm.isVisible() || !cm.isVisibleIndex()) continue;
            ++index;
        }
        return index;
    }

    public void addColumn(ColumnMeta<T> columnMeta) {
        if (columnMeta == null) {
            return;
        }
        if (!this.columnMetaList.contains(columnMeta)) {
            this.columnMetaList.add(columnMeta);
        }
        if (columnMeta.isVisible()) {
            this.dataGrid.addColumn(columnMeta.getColumn(), columnMeta.getHeader());
        }
    }

    protected void sortAndAddColumns(List<ColumnMeta<T>> columnMetas) {
        Collections.sort(columnMetas);
        for (ColumnMeta<T> meta : columnMetas) {
            this.addColumn(meta);
        }
    }

    public void adjustColumnWidths() {
        for (ColumnChangedHandler handler : this.columnChangedHandler) {
            handler.afterColumnChanged();
        }
    }

    public void addColumns(List<ColumnMeta<T>> columnMetas) {
        this.columnMetaList.addAll(columnMetas);
        this.sortAndAddColumns(columnMetas);
        this.adjustColumnWidths();
    }

    public void removeColumn(ColumnMeta<T> columnMeta) {
        this.columnMetaList.remove(columnMeta);
        int count = this.dataGrid.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.dataGrid.removeColumn(0);
        }
        this.sortAndAddColumns(this.columnMetaList);
        this.adjustColumnWidths();
    }

    protected void configureColorPickerPopup(int left, int top, VerticalPanel popupContent) {
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    protected boolean addThisColumnToPopup(ColumnMeta<T> columnMeta) {
        return columnMeta.getHeader().getValue() instanceof String;
    }

    protected void addResetButtom(int left, int top, VerticalPanel popupContent) {
    }

    protected void showColumnPickerPopup(int left, int top) {
        VerticalPanel popupContent = (VerticalPanel)GWT.create(VerticalPanel.class);
        this.initCheckBoxs(popupContent);
        this.addResetButtom(left, top, popupContent);
        this.configureColorPickerPopup(left, top, popupContent);
    }

    protected void initCheckBoxs(VerticalPanel popupContent) {
        for (ColumnMeta<T> columnMeta : this.columnMetaList) {
            if (!this.addThisColumnToPopup(columnMeta)) continue;
            CheckBox checkBox = (CheckBox)GWT.create(CheckBox.class);
            checkBox.setText((String)columnMeta.getHeader().getValue());
            checkBox.setName((String)columnMeta.getHeader().getValue());
            checkBox.setValue(Boolean.valueOf(columnMeta.isVisible()));
            checkBox.addValueChangeHandler(handler -> this.addColumnOnDataGrid((Boolean)handler.getValue(), columnMeta));
            popupContent.add((Widget)checkBox);
        }
    }

    protected void addColumnOnDataGrid(boolean visible, ColumnMeta<T> columnMeta) {
        if (visible) {
            this.dataGrid.insertColumn(this.getVisibleColumnIndex(columnMeta), columnMeta.getColumn(), columnMeta.getHeader());
        } else {
            this.dataGrid.removeColumn(columnMeta.getColumn());
        }
        columnMeta.setVisible(visible);
        this.adjustColumnWidths();
    }

    public Button createToggleButton() {
        final Button button = (Button)GWT.create(Button.class);
        button.addStyleName(UFTableResources.INSTANCE.CSS().columnPickerButton());
        button.setDataToggle(Toggle.BUTTON);
        button.setIcon(IconType.LIST_UL);
        button.setTitle(CommonConstants.INSTANCE.ColumnPickerButtonTooltip());
        this.popup.addStyleName(UFTableResources.INSTANCE.CSS().columnPickerPopup());
        this.popup.addAutoHidePartner((Element)button.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    button.setActive(false);
                }
            }
        });
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!button.isActive()) {
                    UberfireColumnPicker.this.showColumnPickerPopup(button.getAbsoluteLeft() + button.getOffsetWidth(), button.getAbsoluteTop() + button.getOffsetHeight());
                } else {
                    UberfireColumnPicker.this.popup.hide(false);
                }
            }
        });
        return button;
    }

    protected void resetTableColumns(int left, int top) {
        int count = this.dataGrid.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.dataGrid.removeColumn(0);
        }
        this.loadGlobalGridPreferences();
        this.sortAndAddColumns(new ArrayList<ColumnMeta<T>>(this.columnMetaList));
        this.adjustColumnWidths();
        this.showColumnPickerPopup(left, top);
    }

    protected void loadGlobalGridPreferences() {
    }
}

