/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.table.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.Event;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.table.client.ColumnChangedHandler;
import org.uberfire.ext.widgets.table.client.UberfireColumnPicker;

public abstract class ResizableMovableHeader<T>
extends Header<String> {
    private static final Style.Cursor MOVE_CURSOR = Style.Cursor.MOVE;
    private static final String MOVE_COLOR = "gray";
    private static final int MOVE_HANDLE_WIDTH = 32;
    private static final Style.Cursor RESIZE_CURSOR = Style.Cursor.COL_RESIZE;
    private static final String RESIZE_COLOR = "gray";
    private static final int RESIZE_HANDLE_WIDTH = 8;
    private static final double GHOST_OPACITY = 0.3;
    private static final int MINIMUM_COLUMN_WIDTH = 30;
    private final Document document = Document.get();
    private final String title;
    private final DataGrid<T> table;
    private final UberfireColumnPicker columnPicker;
    private final Column<T, ?> column;
    private final Element tableElement;
    private HeaderHelper current;
    private List<ColumnChangedHandler> columnChangedHandlers = new ArrayList<ColumnChangedHandler>();

    public ResizableMovableHeader(String title, DataGrid<T> table, UberfireColumnPicker columnPicker, Column<T, ?> column) {
        super((Cell)new HeaderCell());
        this.title = (String)PortablePreconditions.checkNotNull((String)"title", (Object)title);
        this.table = (DataGrid)PortablePreconditions.checkNotNull((String)"table", table);
        this.columnPicker = (UberfireColumnPicker)PortablePreconditions.checkNotNull((String)"columnPicker", (Object)columnPicker);
        this.column = (Column)PortablePreconditions.checkNotNull((String)"column", column);
        this.tableElement = table.getElement();
    }

    private static NativeEvent getEventAndPreventPropagation(Event.NativePreviewEvent event) {
        NativeEvent nativeEvent = event.getNativeEvent();
        nativeEvent.preventDefault();
        nativeEvent.stopPropagation();
        return nativeEvent;
    }

    private static void setLine(Style style, int width, int top, int height, String color) {
        style.setPosition(Style.Position.ABSOLUTE);
        style.setTop((double)top, Style.Unit.PX);
        style.setHeight((double)height, Style.Unit.PX);
        style.setWidth((double)width, Style.Unit.PX);
        style.setBackgroundColor(color);
        style.setZIndex(Integer.MAX_VALUE);
    }

    public String getValue() {
        return this.title;
    }

    public void onBrowserEvent(Cell.Context context, Element target, NativeEvent event) {
        if (this.current == null) {
            this.current = new HeaderHelper(target, event);
        }
    }

    protected void columnResized(int newWidth) {
        this.table.setColumnWidth(this.column, newWidth + "px");
        this.columnPicker.adjustColumnWidths();
        for (ColumnChangedHandler handler : this.columnChangedHandlers) {
            handler.afterColumnChanged();
        }
    }

    protected void columnMoved(int fromIndex, int beforeIndex) {
        this.columnPicker.columnMoved(fromIndex, beforeIndex);
        this.table.removeColumn(fromIndex);
        this.table.insertColumn(beforeIndex, this.column, (Header)this);
        for (ColumnChangedHandler handler : this.columnChangedHandlers) {
            handler.afterColumnChanged();
        }
    }

    protected abstract int getTableBodyHeight();

    public void addColumnChangedHandler(ColumnChangedHandler handler) {
        if (handler != null) {
            this.columnChangedHandlers.add(handler);
        }
    }

    private class ColumnMoverHelper
    implements Event.NativePreviewHandler {
        private static final int ghostLineWidth = 4;
        private final HandlerRegistration handler = Event.addNativePreviewHandler((Event.NativePreviewHandler)this);
        private final DivElement ghostLine = ResizableMovableHeader.access$000(ResizableMovableHeader.this).createDivElement();
        private final Style ghostLineStyle = this.ghostLine.getStyle();
        private final DivElement ghostColumn = ResizableMovableHeader.access$000(ResizableMovableHeader.this).createDivElement();
        private final Style ghostColumnStyle = this.ghostColumn.getStyle();
        private final int columnWidth;
        private final int[] columnXPositions;
        private final IDragCallback dragCallback;
        private int fromIndex = -1;
        private int toIndex;

        private ColumnMoverHelper(IDragCallback dragCallback, Element target, NativeEvent event) {
            int clientX = event.getClientX();
            Element tr = this.getRowElement(target);
            int columns = tr.getChildCount();
            this.dragCallback = dragCallback;
            this.columnWidth = target.getOffsetWidth();
            this.columnXPositions = new int[columns + 1];
            this.columnXPositions[0] = tr.getAbsoluteLeft();
            for (int i = 0; i < columns; ++i) {
                int xPos = this.columnXPositions[i] + ((Element)tr.getChild(i)).getOffsetWidth();
                if (xPos > clientX && this.fromIndex == -1) {
                    this.fromIndex = i;
                }
                this.columnXPositions[i + 1] = xPos;
            }
            this.toIndex = this.fromIndex;
            int bodyHeight = ResizableMovableHeader.this.getTableBodyHeight();
            ResizableMovableHeader.setLine(this.ghostColumnStyle, this.columnWidth, 0, bodyHeight, "gray");
            ResizableMovableHeader.setLine(this.ghostLineStyle, 4, 0, bodyHeight, "gray");
            this.ghostColumnStyle.setOpacity(0.3);
            this.moveColumn(clientX);
            ResizableMovableHeader.this.tableElement.appendChild((Node)this.ghostColumn);
            ResizableMovableHeader.this.tableElement.appendChild((Node)this.ghostLine);
        }

        protected Element getRowElement(Element target) {
            for (Element parent = target.getParentElement(); parent != null; parent = parent.getParentElement()) {
                if (!parent.getTagName().equalsIgnoreCase("tr")) continue;
                return parent;
            }
            return target.getParentElement();
        }

        public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
            NativeEvent nativeEvent = ResizableMovableHeader.getEventAndPreventPropagation(event);
            String eventType = nativeEvent.getType();
            if ("mousemove".equals(eventType)) {
                this.moveColumn(nativeEvent.getClientX());
            } else if ("mouseup".equals(eventType)) {
                this.handler.removeHandler();
                this.ghostColumn.removeFromParent();
                this.ghostLine.removeFromParent();
                if (this.fromIndex != this.toIndex) {
                    ResizableMovableHeader.this.columnMoved(this.fromIndex, this.toIndex);
                }
                this.dragCallback.dragFinished();
            }
        }

        private void moveColumn(int clientX) {
            int pointer = clientX - this.columnWidth / 2;
            this.ghostColumnStyle.setLeft((double)(pointer - ResizableMovableHeader.this.table.getAbsoluteLeft()), Style.Unit.PX);
            for (int i = 0; i < this.columnXPositions.length - 1; ++i) {
                if (clientX >= this.columnXPositions[i + 1]) continue;
                int adjustedIndex = i > this.fromIndex ? i + 1 : i;
                int lineXPos = this.columnXPositions[adjustedIndex] - ResizableMovableHeader.this.table.getAbsoluteLeft();
                if (adjustedIndex == this.columnXPositions.length - 1) {
                    lineXPos -= 4;
                } else if (adjustedIndex > 0) {
                    lineXPos -= 2;
                }
                this.ghostLineStyle.setLeft((double)lineXPos, Style.Unit.PX);
                this.toIndex = i;
                break;
            }
        }
    }

    private class ColumnResizeHelper
    implements Event.NativePreviewHandler {
        private final HandlerRegistration handler = Event.addNativePreviewHandler((Event.NativePreviewHandler)this);
        private final DivElement resizeLine = ResizableMovableHeader.access$000(ResizableMovableHeader.this).createDivElement();
        private final Style resizeLineStyle = this.resizeLine.getStyle();
        private final Element header;
        private final IDragCallback dragCallback;

        private ColumnResizeHelper(IDragCallback dragCallback, Element header, NativeEvent event) {
            this.dragCallback = dragCallback;
            this.header = header;
            ResizableMovableHeader.setLine(this.resizeLineStyle, 2, 0, ResizableMovableHeader.this.getTableBodyHeight(), "gray");
            this.moveLine(event.getClientX());
            ResizableMovableHeader.this.tableElement.appendChild((Node)this.resizeLine);
        }

        public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
            NativeEvent nativeEvent = ResizableMovableHeader.getEventAndPreventPropagation(event);
            int clientX = nativeEvent.getClientX();
            String eventType = nativeEvent.getType();
            if ("mousemove".equals(eventType)) {
                this.moveLine(clientX);
            } else if ("mouseup".equals(eventType)) {
                this.handler.removeHandler();
                this.resizeLine.removeFromParent();
                this.dragCallback.dragFinished();
                ResizableMovableHeader.this.columnResized(Math.max(clientX - this.header.getAbsoluteLeft(), 30));
            }
        }

        private void moveLine(int clientX) {
            int xPos = clientX - ResizableMovableHeader.this.table.getAbsoluteLeft();
            this.resizeLineStyle.setLeft((double)xPos, Style.Unit.PX);
        }
    }

    private class HeaderHelper
    implements Event.NativePreviewHandler,
    IDragCallback {
        private final HandlerRegistration handler = Event.addNativePreviewHandler((Event.NativePreviewHandler)this);
        private final Element source;
        private final Element handles;
        private final Element moveHandle;
        private final Element resizeHandle;
        private boolean dragging;

        public HeaderHelper(Element target, NativeEvent event) {
            event.preventDefault();
            event.stopPropagation();
            this.source = target;
            this.handles = ResizableMovableHeader.this.document.createDivElement();
            int leftBound = target.getOffsetLeft() + target.getOffsetWidth();
            this.moveHandle = this.createSpanElement(MOVE_CURSOR, leftBound - 8 - 32, 32.0);
            this.resizeHandle = this.createSpanElement(RESIZE_CURSOR, leftBound - 8, 8.0);
            this.handles.appendChild((Node)this.moveHandle);
            this.handles.appendChild((Node)this.resizeHandle);
            this.source.appendChild((Node)this.handles);
        }

        private SpanElement createSpanElement(Style.Cursor cursor, double left, double width) {
            SpanElement span = ResizableMovableHeader.this.document.createSpanElement();
            span.setAttribute("title", ResizableMovableHeader.this.title);
            Style style = span.getStyle();
            style.setCursor(cursor);
            style.setPosition(Style.Position.ABSOLUTE);
            style.setBottom(0.0, Style.Unit.PX);
            style.setHeight((double)this.source.getOffsetHeight(), Style.Unit.PX);
            style.setTop((double)this.source.getOffsetTop(), Style.Unit.PX);
            style.setWidth(width, Style.Unit.PX);
            style.setLeft(left, Style.Unit.PX);
            return span;
        }

        public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
            NativeEvent natEvent = event.getNativeEvent();
            Element element = (Element)natEvent.getEventTarget().cast();
            String eventType = natEvent.getType();
            if (element != this.moveHandle && element != this.resizeHandle) {
                if (!"mousedown".equals(eventType) && !this.dragging && "mouseover".equals(eventType)) {
                    this.cleanUp();
                }
                return;
            }
            NativeEvent nativeEvent = ResizableMovableHeader.getEventAndPreventPropagation(event);
            if ("mousedown".equals(eventType)) {
                if (element == this.resizeHandle) {
                    this.moveHandle.removeFromParent();
                    new ColumnResizeHelper(this, this.source, nativeEvent);
                } else {
                    new ColumnMoverHelper(this, this.source, nativeEvent);
                }
                this.dragging = true;
            }
        }

        private void cleanUp() {
            this.handler.removeHandler();
            this.handles.removeFromParent();
            ResizableMovableHeader.this.current = null;
        }

        @Override
        public void dragFinished() {
            this.dragging = false;
            this.cleanUp();
        }
    }

    private static class HeaderCell
    extends AbstractCell<String> {
        public HeaderCell() {
            super(new String[]{"mousemove"});
        }

        public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
            sb.append(SafeHtmlUtils.fromString((String)value));
        }
    }

    static interface IDragCallback {
        public void dragFinished();
    }
}

