/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.table.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ProvidesKey;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.ext.widgets.table.client.PagedTableHelper;
import org.uberfire.ext.widgets.table.client.UberfireSimplePager;
import org.uberfire.ext.widgets.table.client.UberfireSimpleTable;

public class UberfirePagedTable<T>
extends UberfireSimpleTable<T> {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    public UberfireSimplePager pager;
    @UiField
    public ListBox pageSizesSelector;
    protected boolean showPageSizesSelector = false;
    private int pageSize = 0;
    private AbstractDataProvider<T> dataProvider;

    public UberfirePagedTable() {
        this(10);
    }

    public UberfirePagedTable(int pageSize) {
        this(pageSize, null);
    }

    public UberfirePagedTable(int pageSize, ProvidesKey<T> providesKey) {
        this(pageSize, providesKey, false);
    }

    public UberfirePagedTable(int pageSize, ProvidesKey<T> providesKey, boolean showPageSizesSelector) {
        this(pageSize, providesKey, showPageSizesSelector, false, false);
    }

    public UberfirePagedTable(int pageSize, ProvidesKey<T> providesKey, boolean showPageSizesSelector, boolean showFFButton, boolean showLButton) {
        super(providesKey);
        this.showPageSizesSelector = showPageSizesSelector;
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        PagedTableHelper.setSelectedValue(this.pageSizesSelector, String.valueOf(pageSize));
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.pageSizesSelector.setVisible(this.showPageSizesSelector);
        this.setShowFastFordwardPagerButton(showFFButton);
        this.setShowLastPagerButton(showLButton);
        this.createPageSizesListBox(5, 20, 5);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public AbstractDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(AbstractDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.addDataDisplay((HasData)this);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStart() {
        return this.pager.getPageStart();
    }

    public void createPageSizesListBox(int minPageSize, int maxPageSize, int incPageSize) {
        this.pageSizesSelector.clear();
        PagedTableHelper.setSelectIndexOnPageSizesSelector(minPageSize, maxPageSize, incPageSize, this.pageSizesSelector, this.pageSize);
        this.pageSizesSelector.addChangeHandler(event -> this.loadPageSizePreferences());
        this.loadPageSizePreferences();
    }

    public final void loadPageSizePreferences() {
        this.dataGrid.setPageSize(this.pageSize);
        this.pager.setPageSize(this.pageSize);
        this.dataGrid.setHeight((this.pageSize == 0 ? 1 : this.pageSize) * 30 + 10 + "px");
    }

    public void setShowLastPagerButton(boolean showLastPagerButton) {
        this.pager.setShowLastPageButton(showLastPagerButton);
    }

    public void setShowFastFordwardPagerButton(boolean showFastFordwardPagerButton) {
        this.pager.setShowFastFordwardPageButton(showFastFordwardPagerButton);
    }

    static interface Binder
    extends UiBinder<Widget, UberfirePagedTable> {
    }
}

