/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.api.model.impl.content;

import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.Content;
import org.uberfire.ext.wires.bpmn.api.model.Property;
import org.uberfire.ext.wires.bpmn.api.model.Role;

@Portable
public class DefaultContentImpl
implements Content {
    private String id;
    private String title;
    private String description;
    private Set<Role> roles;
    private Set<Property> properties;

    public DefaultContentImpl(@MapsTo(value="id") String id, @MapsTo(value="title") String title, @MapsTo(value="description") String description, @MapsTo(value="roles") Set<Role> roles, @MapsTo(value="properties") Set<Property> properties) {
        this.id = (String)PortablePreconditions.checkNotNull((String)"id", (Object)id);
        this.title = (String)PortablePreconditions.checkNotNull((String)"title", (Object)title);
        this.description = (String)PortablePreconditions.checkNotNull((String)"description", (Object)description);
        this.roles = (Set)PortablePreconditions.checkNotNull((String)"roles", roles);
        this.properties = (Set)PortablePreconditions.checkNotNull((String)"properties", properties);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<Role> getRoles() {
        return this.roles;
    }

    @Override
    public Set<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Content copy() {
        DefaultContentImpl copy = new DefaultContentImpl(this.id, this.title, this.description, this.copyRoles(this.roles), this.copyProperties(this.properties));
        return copy;
    }

    private Set<Role> copyRoles(Set<Role> roles) {
        HashSet<Role> copy = new HashSet<Role>();
        for (Role role : roles) {
            copy.add((Role)role.copy());
        }
        return copy;
    }

    private Set<Property> copyProperties(Set<Property> properties) {
        HashSet<Property> copy = new HashSet<Property>();
        for (Property property : properties) {
            copy.add((Property)property.copy());
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultContentImpl)) {
            return false;
        }
        DefaultContentImpl that = (DefaultContentImpl)o;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        if (!this.roles.equals(that.roles)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = ~(~result);
        result = 31 * result + this.title.hashCode();
        result = ~(~result);
        result = 31 * result + this.description.hashCode();
        result = ~(~result);
        result = 31 * result + this.roles.hashCode();
        result = ~(~result);
        result = 31 * result + this.properties.hashCode();
        result = ~(~result);
        return result;
    }

    public String toString() {
        return "DefaultContentImpl{id='" + this.id + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", roles=" + this.roles + ", properties=" + this.properties + '}';
    }
}

