/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.backend;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.service.todo.Metadata;
import org.uberfire.ext.wires.bpmn.backend.BpmnServiceImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class BpmnServiceImplTest {
    @Mock
    private SaveAndRenameServiceImpl<ProcessNode, Metadata> saveAndRenameService;
    @Spy
    @InjectMocks
    private BpmnServiceImpl bpmnService = new BpmnServiceImpl();

    @Test(expected=UnsupportedOperationException.class)
    public void bpmnResourceCopyTest() {
        Path path = (Path)Mockito.mock(Path.class);
        String newName = "newName";
        Path targetDirectory = (Path)Mockito.mock(Path.class);
        String comment = "comment";
        this.bpmnService.copy(path, newName, targetDirectory, comment);
    }

    @Test
    public void testSaveAndRename() {
        String newFileName = "newFileName";
        String comment = "comment";
        Path path = (Path)Mockito.mock(Path.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ProcessNode content = (ProcessNode)Mockito.mock(ProcessNode.class);
        this.bpmnService.saveAndRename(path, "newFileName", metadata, content, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(path, "newFileName", (Object)metadata, (Object)content, "comment");
    }
}

