/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import java.util.Collections;
import junit.framework.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.EndProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.StartProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.rules.CardinalityRuleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.AbstractBaseRuleTest;
import org.uberfire.ext.wires.bpmn.client.TestDummyNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultCommandManagerImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DeleteGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;
import org.uberfire.ext.wires.bpmn.client.rules.impl.DefaultRuleManagerImpl;

public class DeleteGraphNodeCommandTest
extends AbstractBaseRuleTest {
    @Test
    public void testDeleteStartProcessNodeFromProcess() {
        ProcessNode process = new ProcessNode();
        StartProcessNode node = new StartProcessNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        ruleManager.addRule((Rule)new CardinalityRuleImpl("Start Node Cardinality Rule", (Role)new DefaultRoleImpl("sequence_start"), 1L, 1L, Collections.EMPTY_SET, Collections.EMPTY_SET));
        process.addNode((BpmnGraphNode)node);
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        Results results = commandManager.execute((RuleManager)ruleManager, (Command)new DeleteGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((int)1, (int)results.getMessages().size());
        Assert.assertEquals((int)1, (int)process.size());
        Assert.assertEquals((Object)node, (Object)process.getNode(node.getId()));
    }

    @Test
    public void testDeleteEndProcessNodeFromProcess() {
        ProcessNode process = new ProcessNode();
        EndProcessNode node = new EndProcessNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        ruleManager.addRule((Rule)new CardinalityRuleImpl("End Node Cardinality Rule", (Role)new DefaultRoleImpl("sequence_end"), 1L, 1L, Collections.EMPTY_SET, Collections.EMPTY_SET));
        process.addNode((BpmnGraphNode)node);
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        Results results = commandManager.execute((RuleManager)ruleManager, (Command)new DeleteGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((int)1, (int)results.getMessages().size());
        Assert.assertEquals((int)1, (int)process.size());
        Assert.assertEquals((Object)node, (Object)process.getNode(node.getId()));
    }

    @Test
    public void testDeleteDummyNodeFromProcess() {
        ProcessNode process = new ProcessNode();
        TestDummyNode node = new TestDummyNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        for (Rule rule : this.getContainmentRules()) {
            ruleManager.addRule(rule);
        }
        process.addNode((BpmnGraphNode)node);
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        Results results = commandManager.execute((RuleManager)ruleManager, (Command)new DeleteGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node));
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((int)0, (int)results.getMessages().size());
        Assert.assertEquals((int)0, (int)process.size());
    }
}

