/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.rules.impl;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.edges.BpmnEdgeImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.EndProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.StartProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.AbstractBaseRuleTest;
import org.uberfire.ext.wires.bpmn.client.TestDummyNode;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;
import org.uberfire.ext.wires.bpmn.client.rules.impl.DefaultRuleManagerImpl;

public class ConnectionRulesTest
extends AbstractBaseRuleTest {
    private ProcessNode process;
    private RuleManager ruleManager;
    private StartProcessNode node1;
    private TestDummyNode node2;
    private EndProcessNode node3;

    @Before
    public void setupNodes() {
        this.process = new ProcessNode();
        this.ruleManager = new DefaultRuleManagerImpl();
        this.node1 = new StartProcessNode();
        this.node2 = new TestDummyNode();
        this.node3 = new EndProcessNode();
        for (Rule rule : this.getConnectionRules()) {
            this.ruleManager.addRule(rule);
        }
        this.process.addNode((BpmnGraphNode)this.node1);
        this.process.addNode((BpmnGraphNode)this.node2);
        this.process.addNode((BpmnGraphNode)this.node3);
    }

    @Test
    public void testAddEdgeBetweenStartNodeAndDummyNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.ruleManager.checkConnectionRules((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, (BpmnEdge)e1);
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
    }

    @Test
    public void testAddEdgeBetweenDummyNodeAndEndNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.ruleManager.checkConnectionRules((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, (BpmnEdge)e1);
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
    }

    @Test
    public void testAddEdgeBetweenStartNodeAndEndNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.ruleManager.checkConnectionRules((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node3, (BpmnEdge)e1);
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)1, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)results1.getMessages(ResultType.ERROR).size());
    }
}

