/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import java.util.Collections;
import junit.framework.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.EndProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.StartProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.rules.CardinalityRuleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.AbstractBaseRuleTest;
import org.uberfire.ext.wires.bpmn.client.TestDummyNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultCommandManagerImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;
import org.uberfire.ext.wires.bpmn.client.rules.impl.DefaultRuleManagerImpl;

public class CommandManagerTest
extends AbstractBaseRuleTest {
    @Test
    public void testAddOneNodeToProcess() {
        ProcessNode process = new ProcessNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        for (Rule rule : this.getContainmentRules()) {
            ruleManager.addRule(rule);
        }
        for (Rule rule : this.getCardinalityRules()) {
            ruleManager.addRule(rule);
        }
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        StartProcessNode node1 = new StartProcessNode();
        Results results1 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node1));
        Assert.assertEquals((Object)node1, (Object)process.getNode(node1.getId()));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node1});
    }

    @Test
    public void testAddTwoNodesToProcess() {
        ProcessNode process = new ProcessNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        for (Rule rule : this.getContainmentRules()) {
            ruleManager.addRule(rule);
        }
        for (Rule rule : this.getCardinalityRules()) {
            ruleManager.addRule(rule);
        }
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        StartProcessNode node1 = new StartProcessNode();
        EndProcessNode node2 = new EndProcessNode();
        Results results1 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node1));
        Assert.assertEquals((Object)node1, (Object)process.getNode(node1.getId()));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Results results2 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node2));
        Assert.assertEquals((Object)node2, (Object)process.getNode(node2.getId()));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)0, (int)results2.getMessages().size());
        Assert.assertEquals((int)2, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node1, node2});
    }

    @Test
    public void testAddTwoNodesToProcessThenUndo() {
        ProcessNode process = new ProcessNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        for (Rule rule : this.getContainmentRules()) {
            ruleManager.addRule(rule);
        }
        for (Rule rule : this.getCardinalityRules()) {
            ruleManager.addRule(rule);
        }
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        StartProcessNode node1 = new StartProcessNode();
        EndProcessNode node2 = new EndProcessNode();
        Results results1 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node1});
        Results results2 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node2));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)0, (int)results2.getMessages().size());
        Assert.assertEquals((int)2, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node1, node2});
        commandManager.undo((RuleManager)ruleManager);
        Assert.assertEquals((int)1, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node1});
        this.assertProcessNotContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node2});
        commandManager.undo((RuleManager)ruleManager);
        Assert.assertEquals((int)0, (int)process.size());
        this.assertProcessNotContainsNodes((BpmnGraph)process, new BpmnGraphNode[]{node1, node2});
    }

    @Test
    public void testAddNotPermittedNodesToProcess() {
        ProcessNode process = new ProcessNode();
        DefaultRuleManagerImpl ruleManager = new DefaultRuleManagerImpl();
        ruleManager.addRule((Rule)new CardinalityRuleImpl("TestDummyNode Cardinality Rule", (Role)new DefaultRoleImpl("dummy"), 0L, 1L, Collections.EMPTY_SET, Collections.EMPTY_SET));
        TestDummyNode node1 = new TestDummyNode();
        TestDummyNode node2 = new TestDummyNode();
        DefaultCommandManagerImpl commandManager = new DefaultCommandManagerImpl();
        Results results1 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, node1);
        Results results2 = commandManager.execute((RuleManager)ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)process, (BpmnGraphNode)node2));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)process.size());
        this.assertProcessContainsNodes((BpmnGraph)process, node1);
        this.assertProcessNotContainsNodes((BpmnGraph)process, node2);
        commandManager.undo((RuleManager)ruleManager);
        Assert.assertEquals((int)0, (int)process.size());
        this.assertProcessNotContainsNodes((BpmnGraph)process, node1, node2);
    }
}

