/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.edges.BpmnEdgeImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.EndProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.StartProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.AbstractBaseRuleTest;
import org.uberfire.ext.wires.bpmn.client.TestDummyNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.CommandManager;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddEdgeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultCommandManagerImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;
import org.uberfire.ext.wires.bpmn.client.rules.impl.DefaultRuleManagerImpl;

public class AddEdgeCommandTest
extends AbstractBaseRuleTest {
    private ProcessNode process;
    private RuleManager ruleManager;
    private StartProcessNode node1;
    private TestDummyNode node2;
    private EndProcessNode node3;
    private CommandManager commandManager;

    @Before
    public void setupNodes() {
        this.process = new ProcessNode();
        this.ruleManager = new DefaultRuleManagerImpl();
        this.node1 = new StartProcessNode();
        this.node2 = new TestDummyNode();
        this.node3 = new EndProcessNode();
        this.commandManager = new DefaultCommandManagerImpl();
        for (Rule rule : this.getConnectionRules()) {
            this.ruleManager.addRule(rule);
        }
        for (Rule rule : this.getCardinalityRules()) {
            this.ruleManager.addRule(rule);
        }
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node2));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)0, (int)results2.getMessages().size());
        Results results3 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node3));
        Assert.assertNotNull((Object)results3);
        Assert.assertEquals((int)0, (int)results3.getMessages().size());
    }

    @Test
    public void testAddEdgeBetweenStartNodeAndDummyNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)0, (int)this.node1.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node1.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((Object)e1, (Object)this.node1.getOutEdges().toArray()[0]);
        Assert.assertEquals((Object)e1, (Object)this.node2.getInEdges().toArray()[0]);
    }

    @Test
    public void testAddEdgeBetweenDummyNodeAndEndNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)0, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getOutEdges().size());
        Assert.assertEquals((Object)e1, (Object)this.node2.getOutEdges().toArray()[0]);
        Assert.assertEquals((Object)e1, (Object)this.node3.getInEdges().toArray()[0]);
    }

    @Test
    public void testAddEdgeBetweenStartNodeAndEndNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node3, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)1, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)results1.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)0, (int)this.node1.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node1.getOutEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getOutEdges().size());
    }

    @Test
    public void testStartNodeOutgoingCardinalityAndDummyNode() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)0, (int)this.node1.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node1.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((Object)e1, (Object)this.node1.getOutEdges().toArray()[0]);
        Assert.assertEquals((Object)e1, (Object)this.node2.getInEdges().toArray()[0]);
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)results2.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)0, (int)this.node1.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node1.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((Object)e1, (Object)this.node1.getOutEdges().toArray()[0]);
        Assert.assertEquals((Object)e1, (Object)this.node2.getInEdges().toArray()[0]);
    }

    @Test
    public void testDummyNodeAndEndNodeIncomingCardinality() {
        BpmnEdgeImpl e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)0, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getOutEdges().size());
        Assert.assertEquals((Object)e1, (Object)this.node2.getOutEdges().toArray()[0]);
        Assert.assertEquals((Object)e1, (Object)this.node3.getInEdges().toArray()[0]);
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, (BpmnEdge)e1));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)results2.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)0, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getOutEdges().size());
        Assert.assertEquals((Object)e1, (Object)this.node2.getOutEdges().toArray()[0]);
        Assert.assertEquals((Object)e1, (Object)this.node3.getInEdges().toArray()[0]);
    }
}

