/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.edges.BpmnEdgeImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.EndProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.StartProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.AbstractBaseRuleTest;
import org.uberfire.ext.wires.bpmn.client.TestDummyNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.CommandManager;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddEdgeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.BatchCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultCommandManagerImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;
import org.uberfire.ext.wires.bpmn.client.rules.impl.DefaultRuleManagerImpl;

public class BatchCommandTest
extends AbstractBaseRuleTest {
    private ProcessNode process;
    private RuleManager ruleManager;
    private StartProcessNode node1;
    private TestDummyNode node2;
    private EndProcessNode node3;
    private BpmnEdge e1;
    private BpmnEdge e2;
    private CommandManager commandManager;

    @Before
    public void setupNodes() {
        this.process = new ProcessNode();
        this.ruleManager = new DefaultRuleManagerImpl();
        this.node1 = new StartProcessNode();
        this.node2 = new TestDummyNode();
        this.node3 = new EndProcessNode();
        this.commandManager = new DefaultCommandManagerImpl();
        for (Rule rule : this.getConnectionRules()) {
            this.ruleManager.addRule(rule);
        }
        for (Rule rule : this.getCardinalityRules()) {
            this.ruleManager.addRule(rule);
        }
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node2));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)0, (int)results2.getMessages().size());
        Results results3 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node3));
        Assert.assertNotNull((Object)results3);
        Assert.assertEquals((int)0, (int)results3.getMessages().size());
        this.e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results4 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, this.e1));
        Assert.assertNotNull((Object)results4);
        Assert.assertEquals((int)0, (int)results4.getMessages().size());
        this.e2 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results5 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e2));
        Assert.assertNotNull((Object)results5);
        Assert.assertEquals((int)0, (int)results5.getMessages().size());
    }

    @Test
    public void testBatchAddValidState() {
        TestDummyNode testNode1 = new TestDummyNode();
        TestDummyNode testNode2 = new TestDummyNode();
        BpmnEdgeImpl testEdge1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        BpmnEdgeImpl testEdge2 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        AddGraphNodeCommand testCmd1 = new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)testNode1);
        AddGraphNodeCommand testCmd2 = new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)testNode2);
        AddEdgeCommand testCmd3 = new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)testNode1, (BpmnEdge)testEdge1);
        AddEdgeCommand testCmd4 = new AddEdgeCommand((BpmnGraphNode)testNode1, (BpmnGraphNode)testNode2, (BpmnEdge)testEdge2);
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new BatchCommand(new Command[]{testCmd1, testCmd2, testCmd3, testCmd4}));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)5, (int)this.process.size());
        this.assertProcessContainsNodes((BpmnGraph)this.process, testNode1, testNode2);
        Assert.assertEquals((int)2, (int)this.node2.getOutEdges().size());
        this.assertNodeContainsOutgoingEdges(this.node2, new BpmnEdge[]{this.e2, testEdge1});
        Assert.assertEquals((int)1, (int)testNode1.getInEdges().size());
        this.assertNodeContainsIncomingEdges(testNode1, new BpmnEdge[]{testEdge1});
        Assert.assertEquals((int)1, (int)testNode1.getOutEdges().size());
        this.assertNodeContainsOutgoingEdges(testNode1, new BpmnEdge[]{testEdge2});
        Assert.assertEquals((int)1, (int)testNode2.getInEdges().size());
        this.assertNodeContainsIncomingEdges(testNode2, new BpmnEdge[]{testEdge2});
    }

    @Test
    public void testBatchAddInvalidState1() {
        TestDummyNode testNode1 = new TestDummyNode();
        EndProcessNode testNode2 = new EndProcessNode();
        BpmnEdgeImpl testEdge1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        BpmnEdgeImpl testEdge2 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        AddGraphNodeCommand testCmd1 = new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)testNode1);
        AddGraphNodeCommand testCmd2 = new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)testNode2);
        AddEdgeCommand testCmd3 = new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)testNode1, (BpmnEdge)testEdge1);
        AddEdgeCommand testCmd4 = new AddEdgeCommand((BpmnGraphNode)testNode1, (BpmnGraphNode)testNode2, (BpmnEdge)testEdge2);
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new BatchCommand(new Command[]{testCmd1, testCmd2, testCmd3, testCmd4}));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)1, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)results1.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)3, (int)this.process.size());
        this.assertProcessNotContainsNodes((BpmnGraph)this.process, new BpmnGraphNode[]{testNode1, testNode2});
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        this.assertNodeContainsOutgoingEdges(this.node2, this.e2);
        Assert.assertEquals((int)0, (int)testNode1.getInEdges().size());
        Assert.assertEquals((int)0, (int)testNode1.getOutEdges().size());
        Assert.assertEquals((int)0, (int)testNode2.getInEdges().size());
    }

    @Test
    public void testBatchAddInvalidState2() {
        TestDummyNode testNode1 = new TestDummyNode();
        BpmnEdgeImpl testEdge1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        AddGraphNodeCommand testCmd1 = new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)testNode1);
        AddEdgeCommand testCmd2 = new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)testNode1, (BpmnEdge)testEdge1);
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new BatchCommand(new Command[]{testCmd1, testCmd2}));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)1, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)results1.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)3, (int)this.process.size());
        this.assertProcessNotContainsNodes((BpmnGraph)this.process, testNode1);
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        this.assertNodeContainsOutgoingEdges(this.node2, this.e2);
        Assert.assertEquals((int)0, (int)testNode1.getInEdges().size());
        Assert.assertEquals((int)0, (int)testNode1.getOutEdges().size());
    }
}

