/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.edges.BpmnEdgeImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.EndProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.StartProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.rules.CardinalityRuleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.CardinalityRule;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.AbstractBaseRuleTest;
import org.uberfire.ext.wires.bpmn.client.TestDummyNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.CommandManager;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddEdgeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddGraphNodeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultCommandManagerImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DeleteEdgeCommand;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;
import org.uberfire.ext.wires.bpmn.client.rules.impl.DefaultRuleManagerImpl;

public class DeleteEdgeCommandTest
extends AbstractBaseRuleTest {
    private ProcessNode process;
    private RuleManager ruleManager;
    private StartProcessNode node1;
    private TestDummyNode node2;
    private TestDummyNode node3;
    private EndProcessNode node4;
    private BpmnEdge e1;
    private BpmnEdge e2;
    private BpmnEdge e3;
    private BpmnEdge e4;
    private CommandManager commandManager;

    @Before
    public void setupNodes() {
        this.process = new ProcessNode();
        this.ruleManager = new DefaultRuleManagerImpl();
        this.node1 = new StartProcessNode();
        this.node2 = new TestDummyNode();
        this.node3 = new TestDummyNode();
        this.node4 = new EndProcessNode();
        this.commandManager = new DefaultCommandManagerImpl();
        for (Rule rule : this.getConnectionRules()) {
            this.ruleManager.addRule(rule);
        }
        for (Rule rule : this.getCardinalityRules()) {
            this.ruleManager.addRule(rule);
        }
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node2));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)0, (int)results2.getMessages().size());
        Results results3 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node3));
        Assert.assertNotNull((Object)results3);
        Assert.assertEquals((int)0, (int)results3.getMessages().size());
        Results results4 = this.commandManager.execute(this.ruleManager, (Command)new AddGraphNodeCommand((BpmnGraph)this.process, (BpmnGraphNode)this.node4));
        Assert.assertNotNull((Object)results4);
        Assert.assertEquals((int)0, (int)results4.getMessages().size());
        this.e1 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results5 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, this.e1));
        Assert.assertNotNull((Object)results5);
        Assert.assertEquals((int)0, (int)results5.getMessages().size());
        this.e2 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results6 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e2));
        Assert.assertNotNull((Object)results6);
        Assert.assertEquals((int)0, (int)results6.getMessages().size());
        this.e3 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results7 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node3, (BpmnGraphNode)this.node4, this.e3));
        Assert.assertNotNull((Object)results7);
        Assert.assertEquals((int)0, (int)results7.getMessages().size());
        this.e4 = new BpmnEdgeImpl((Role)new DefaultRoleImpl("general_edge"));
        Results results8 = this.commandManager.execute(this.ruleManager, (Command)new AddEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e4));
        Assert.assertNotNull((Object)results8);
        Assert.assertEquals((int)0, (int)results8.getMessages().size());
    }

    @Test
    public void testDeleteEdgeBetweenStartNodeAndDummyNode() {
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, this.e1));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)0, (int)this.node1.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node1.getOutEdges().size());
        Assert.assertEquals((int)0, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)2, (int)this.node2.getOutEdges().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node1, (BpmnGraphNode)this.node2, this.e1));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)results2.getMessages(ResultType.WARNING).size());
        Assert.assertEquals((int)0, (int)this.node1.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node1.getOutEdges().size());
        Assert.assertEquals((int)0, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)2, (int)this.node2.getOutEdges().size());
    }

    @Test
    public void testDeleteEdgeBetweenDummyNodeAndEndNode() {
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node3, (BpmnGraphNode)this.node4, this.e3));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)2, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getOutEdges().size());
        Assert.assertEquals((int)0, (int)this.node4.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node4.getOutEdges().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node3, (BpmnGraphNode)this.node4, this.e3));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)results2.getMessages(ResultType.WARNING).size());
        Assert.assertEquals((int)2, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node3.getOutEdges().size());
        Assert.assertEquals((int)0, (int)this.node4.getInEdges().size());
        Assert.assertEquals((int)0, (int)this.node4.getOutEdges().size());
    }

    @Test
    public void testDeleteOutgoingCardinalityOutgoingMinimum() {
        this.ruleManager.addRule((Rule)new CardinalityRuleImpl("DummyNode Outgoing Cardinality Rule", (Role)new DefaultRoleImpl("dummy"), 0L, 2L, (Set)new HashSet<CardinalityRule.ConnectorRule>(){
            {
                this.add(new CardinalityRule.ConnectorRule(){

                    public long getMinOccurrences() {
                        return 1L;
                    }

                    public long getMaxOccurrences() {
                        return 2L;
                    }

                    public Role getRole() {
                        return new DefaultRoleImpl("general_edge");
                    }

                    public String getName() {
                        return "End Node DummyNode Connector Rule 1";
                    }
                });
            }
        }, Collections.EMPTY_SET));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e2));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getOutEdges().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e4));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)results2.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getOutEdges().size());
    }

    @Test
    public void testDeleteOutgoingCardinalityIncomingMinimum() {
        this.ruleManager.addRule((Rule)new CardinalityRuleImpl("DummyNode Incoming Cardinality Rule", (Role)new DefaultRoleImpl("dummy"), 0L, 2L, Collections.EMPTY_SET, (Set)new HashSet<CardinalityRule.ConnectorRule>(){
            {
                this.add(new CardinalityRule.ConnectorRule(){

                    public long getMinOccurrences() {
                        return 1L;
                    }

                    public long getMaxOccurrences() {
                        return 2L;
                    }

                    public Role getRole() {
                        return new DefaultRoleImpl("general_edge");
                    }

                    public String getName() {
                        return "End Node DummyNode Connector Rule 1";
                    }
                });
            }
        }));
        Results results1 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e2));
        Assert.assertNotNull((Object)results1);
        Assert.assertEquals((int)0, (int)results1.getMessages().size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getOutEdges().size());
        Results results2 = this.commandManager.execute(this.ruleManager, (Command)new DeleteEdgeCommand((BpmnGraphNode)this.node2, (BpmnGraphNode)this.node3, this.e4));
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((int)1, (int)results2.getMessages().size());
        Assert.assertEquals((int)1, (int)results2.getMessages(ResultType.ERROR).size());
        Assert.assertEquals((int)1, (int)this.node2.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node2.getOutEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getInEdges().size());
        Assert.assertEquals((int)1, (int)this.node3.getOutEdges().size());
    }
}

