/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.uberfire.commons.validation.PortablePreconditions;

public class CustomPanelScreenWrapper {
    private final WebDriver driver;

    public CustomPanelScreenWrapper(WebDriver driver) {
        this.driver = (WebDriver)PortablePreconditions.checkNotNull((String)"driver", (Object)driver);
    }

    public int getLiveInstanceCount() {
        WebElement label = this.findElement("liveCustomPanelInstances");
        Pattern p = Pattern.compile("Live Instances: ([0-9]*)");
        Matcher m = p.matcher(label.getText());
        if (m.matches()) {
            return Integer.parseInt(m.group(1));
        }
        throw new IllegalStateException("Couldn't find live instance count label on page");
    }

    public int getTotalInstanceCount() {
        WebElement label = this.findElement("totalCustomPanelInstances");
        Pattern p = Pattern.compile("Total Instances: ([0-9]*)");
        Matcher m = p.matcher(label.getText());
        if (m.matches()) {
            return Integer.parseInt(m.group(1));
        }
        throw new IllegalStateException("Couldn't find total instance count label on page");
    }

    public String createCustomPopup() {
        int previousTotalInstances = this.getTotalInstanceCount();
        WebElement button = this.findElement("open");
        button.click();
        return "CustomPanelContentScreen-" + previousTotalInstances;
    }

    public boolean customPopupExistsInDom(String id) {
        List found = this.driver.findElements(By.id((String)("gwt-debug-" + id)));
        return !found.isEmpty();
    }

    public void closeLatestPopupUsingPlaceManager() {
        WebElement button = this.findElement("closeWithPlaceManager");
        button.click();
    }

    public void closeLatestPopupByRemovingFromDom() {
        WebElement button = this.findElement("closeByRemovingFromDom");
        button.click();
    }

    private WebElement findElement(String shortName) {
        return this.driver.findElement(By.id((String)("gwt-debug-CustomPanelMakerScreen-" + shortName)));
    }
}

