/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.wbtest.client.perspective.ListPerspectiveActivity;
import org.uberfire.wbtest.client.perspective.SimplePerspectiveActivity;
import org.uberfire.wbtest.client.perspective.StaticPerspectiveActivity;
import org.uberfire.wbtest.client.perspective.TabbedPerspectiveActivity;
import org.uberfire.wbtest.client.resize.ResizeTestScreenActivity;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.ResizeWidgetWrapper;
import org.uberfire.wbtest.selenium.TopHeaderWrapper;
import org.uberfire.workbench.model.CompassPosition;

public class WorkbenchResizeTest
extends AbstractSeleniumTest {
    @Test
    public void testDefaultPerspectiveSize() throws Exception {
        this.driver.get(this.baseUrl + "#" + ResizeTestScreenActivity.class.getName() + "?debugId=addedInDefaultPerspective");
        ResizeWidgetWrapper widgetWrapper = new ResizeWidgetWrapper(this.driver, "addedInDefaultPerspective");
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getReportedSize());
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getActualSize());
    }

    @Test
    public void testSimplePerspectiveSize() throws Exception {
        this.driver.get(this.baseUrl + "#" + SimplePerspectiveActivity.class.getName());
        ResizeWidgetWrapper widgetWrapper = new ResizeWidgetWrapper(this.driver, "simplePerspectiveDefault");
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getReportedSize());
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getActualSize());
    }

    @Test
    public void testListPerspectiveSize() throws Exception {
        this.driver.get(this.baseUrl + "#" + ListPerspectiveActivity.class.getName());
        ResizeWidgetWrapper widgetWrapper = new ResizeWidgetWrapper(this.driver, "listPerspectiveDefault");
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getReportedSize());
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getActualSize());
    }

    @Test
    public void testListPerspectiveSizeWithNestedPanels() throws Exception {
        this.driver.get(this.baseUrl + "#" + ListPerspectiveActivity.class.getName());
        ResizeWidgetWrapper widgetWrapper = new ResizeWidgetWrapper(this.driver, "listPerspectiveDefault");
        TopHeaderWrapper topHeaderWrapper = new TopHeaderWrapper(this.driver);
        topHeaderWrapper.addPanelToRoot(CompassPosition.WEST, MultiListWorkbenchPanelPresenter.class, ResizeTestScreenActivity.class, "id", "resize1");
        Dimension sizeAfterWestPanelAdded = widgetWrapper.getActualSize();
        topHeaderWrapper.addPanelToRoot(CompassPosition.EAST, MultiListWorkbenchPanelPresenter.class, ResizeTestScreenActivity.class, "id", "resize2");
        Dimension sizeAfterBothPanelsAdded = widgetWrapper.getActualSize();
        Assert.assertTrue((sizeAfterWestPanelAdded.width < 1000 ? 1 : 0) != 0);
        Assert.assertTrue((sizeAfterBothPanelsAdded.width < sizeAfterWestPanelAdded.width ? 1 : 0) != 0);
    }

    @Test
    public void testTabbedPerspectiveSize() throws Exception {
        this.driver.get(this.baseUrl + "#" + TabbedPerspectiveActivity.class.getName());
        ResizeWidgetWrapper widgetWrapper = new ResizeWidgetWrapper(this.driver, "tabbedPerspectiveDefault");
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getReportedSize());
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getActualSize());
    }

    @Test
    public void testStaticPerspectiveSize() throws Exception {
        this.driver.get(this.baseUrl + "#" + StaticPerspectiveActivity.class.getName());
        ResizeWidgetWrapper widgetWrapper = new ResizeWidgetWrapper(this.driver, "staticPerspectiveDefault");
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getReportedSize());
        Assert.assertEquals((Object)new Dimension(1000, 20), (Object)widgetWrapper.getActualSize());
    }

    @Test
    public void ensureEmptyFooterIsNotAttachedToPage() throws Exception {
        this.driver.get(this.baseUrl + "?" + "disableHeadersAndFooters" + "=true");
        this.waitForDefaultPerspective();
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        List footers = this.driver.findElements(By.id((String)"gwt-debug-workbenchFooterPanel"));
        Assert.assertTrue((boolean)footers.isEmpty());
    }

    @Test
    public void ensureEmptyHeaderIsNotAttachedToPage() throws Exception {
        this.driver.get(this.baseUrl + "?" + "disableHeadersAndFooters" + "=true");
        this.waitForDefaultPerspective();
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        List footers = this.driver.findElements(By.id((String)"gwt-debug-workbenchHeaderPanel"));
        Assert.assertTrue((boolean)footers.isEmpty());
    }
}

