/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.gwttest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.errai.enterprise.client.cdi.AbstractCDIEventCallback;
import org.jboss.errai.enterprise.client.cdi.api.CDI;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.client.mvp.ActivityLifecycleError;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.debug.Debug;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.wbtest.client.breakable.BreakableMenuScreen;
import org.uberfire.wbtest.client.breakable.BreakablePerspective;
import org.uberfire.wbtest.client.breakable.BreakableScreen;
import org.uberfire.wbtest.client.main.DefaultPerspectiveActivity;
import org.uberfire.wbtest.client.main.DefaultScreenActivity;
import org.uberfire.wbtest.gwttest.AbstractUberFireGwtTest;
import org.uberfire.wbtest.gwttest.TestingPredicates;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;

public class BrokenLifecycleTest
extends AbstractUberFireGwtTest {
    private PlaceManager placeManager;
    private ActivityManager activityManager;
    private PanelManager panelManager;
    private PerspectiveManager perspectiveManager;
    private final LifecycleErrorLogger lifecycleErrorLog = new LifecycleErrorLogger();
    private static final Predicate<Void> BREAKABLE_MENU_NOT_VISIBLE = new Predicate<Void>(){

        public boolean apply(Void input) {
            return DOM.getElementById((String)Debug.shortName(BreakableMenuScreen.class)) == null;
        }
    };
    private static final Predicate<Void> BREAKABLE_SCREEN_NOT_VISIBLE = new Predicate<Void>(){

        public boolean apply(Void input) {
            Element element = DOM.getElementById((String)Debug.shortName(BreakableScreen.class));
            return element == null;
        }
    };

    @Override
    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.placeManager = (PlaceManager)IOC.getBeanManager().lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
        this.activityManager = (ActivityManager)IOC.getBeanManager().lookupBean(ActivityManager.class, new Annotation[0]).getInstance();
        this.panelManager = (PanelManager)IOC.getBeanManager().lookupBean(PanelManager.class, new Annotation[0]).getInstance();
        this.perspectiveManager = (PerspectiveManager)IOC.getBeanManager().lookupBean(PerspectiveManager.class, new Annotation[0]).getInstance();
        CDI.subscribeLocal((String)ActivityLifecycleError.class.getName(), (AbstractCDIEventCallback)this.lifecycleErrorLog);
    }

    public void testBrokenPerspectiveStartup() throws Exception {
        final PlaceRequest brokenPerspectivePlace = DefaultPlaceRequest.parse((CharSequence)(BreakablePerspective.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.STARTUP));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenPerspectivePlace);
            }
        }).thenDelay(500).thenPollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultScreenActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenPerspectivePlace));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(BreakableMenuScreen.class.getName()));
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakablePerspective.class, ActivityLifecycleError.LifecyclePhase.STARTUP));
            }
        });
    }

    public void testBrokenPerspectiveOpen() throws Exception {
        final PlaceRequest brokenPerspectivePlace = DefaultPlaceRequest.parse((CharSequence)(BreakablePerspective.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.OPEN));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenPerspectivePlace);
            }
        }).thenDelay(500).thenPollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((String)DefaultPerspectiveActivity.class.getName(), (String)BrokenLifecycleTest.this.perspectiveManager.getCurrentPerspective().getPlace().getIdentifier());
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultScreenActivity.class.getName()));
                TestCase.assertNull((Object)BrokenLifecycleTest.this.placeManager.getActivity(brokenPerspectivePlace));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenPerspectivePlace));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(BreakableMenuScreen.class.getName()));
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakablePerspective.class, ActivityLifecycleError.LifecyclePhase.OPEN));
            }
        });
    }

    public void testBrokenPerspectiveClose() throws Exception {
        final PlaceRequest brokenPerspectivePlace = DefaultPlaceRequest.parse((CharSequence)(BreakablePerspective.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.CLOSE));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenPerspectivePlace);
            }
        }).thenPollWhile(BREAKABLE_MENU_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(DefaultPerspectiveActivity.class.getName());
            }
        }).thenPollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenPerspectivePlace));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(BreakableMenuScreen.class.getName()));
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakablePerspective.class, ActivityLifecycleError.LifecyclePhase.CLOSE));
            }
        });
    }

    public void testBrokenPerspectiveShutdown() throws Exception {
        final PlaceRequest brokenPerspectivePlace = DefaultPlaceRequest.parse((CharSequence)(BreakablePerspective.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.SHUTDOWN));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenPerspectivePlace);
            }
        }).thenPollWhile(BREAKABLE_MENU_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(DefaultPerspectiveActivity.class.getName());
            }
        }).thenPollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenPerspectivePlace));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(BreakableMenuScreen.class.getName()));
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakablePerspective.class, ActivityLifecycleError.LifecyclePhase.SHUTDOWN));
            }
        });
    }

    public void testBrokenScreenStartup() throws Exception {
        final PlaceRequest brokenScreenPlace = DefaultPlaceRequest.parse((CharSequence)(BreakableScreen.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.STARTUP));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenScreenPlace);
            }
        }).thenDelay(500).thenPollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultScreenActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenScreenPlace));
                BrokenLifecycleTest.this.assertPanelDoesNotContain(BrokenLifecycleTest.this.panelManager.getRoot(), brokenScreenPlace);
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakableScreen.class, ActivityLifecycleError.LifecyclePhase.STARTUP));
            }
        });
    }

    public void testBrokenScreenOpen() throws Exception {
        final PlaceRequest brokenScreenPlace = DefaultPlaceRequest.parse((CharSequence)(BreakableScreen.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.OPEN));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenScreenPlace);
            }
        }).thenDelay(500).thenPollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultScreenActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenScreenPlace));
                BrokenLifecycleTest.this.assertPanelDoesNotContain(BrokenLifecycleTest.this.panelManager.getRoot(), brokenScreenPlace);
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakableScreen.class, ActivityLifecycleError.LifecyclePhase.OPEN));
            }
        });
    }

    public void testBrokenScreenClose() throws Exception {
        final PlaceRequest brokenScreenPlace = DefaultPlaceRequest.parse((CharSequence)(BreakableScreen.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.CLOSE));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenScreenPlace);
            }
        }).thenPollWhile(BREAKABLE_SCREEN_NOT_VISIBLE).thenDelay(500).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.closePlace(brokenScreenPlace);
            }
        }).thenPollWhile((Predicate<Void>)Predicates.not(BREAKABLE_SCREEN_NOT_VISIBLE)).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultScreenActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenScreenPlace));
                BrokenLifecycleTest.this.assertPanelDoesNotContain(BrokenLifecycleTest.this.panelManager.getRoot(), brokenScreenPlace);
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakableScreen.class, ActivityLifecycleError.LifecyclePhase.CLOSE));
            }
        });
    }

    public void testBrokenScreenShutdown() throws Exception {
        final PlaceRequest brokenScreenPlace = DefaultPlaceRequest.parse((CharSequence)(BreakableScreen.class.getName() + "?broken=" + ActivityLifecycleError.LifecyclePhase.SHUTDOWN));
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.goTo(brokenScreenPlace);
            }
        }).thenPollWhile(BREAKABLE_SCREEN_NOT_VISIBLE).thenDelay(500).thenDo(new Runnable(){

            @Override
            public void run() {
                BrokenLifecycleTest.this.placeManager.closePlace(brokenScreenPlace);
            }
        }).thenPollWhile((Predicate<Void>)Predicates.not(BREAKABLE_SCREEN_NOT_VISIBLE)).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultPerspectiveActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.OPEN, (Object)BrokenLifecycleTest.this.placeManager.getStatus(DefaultScreenActivity.class.getName()));
                TestCase.assertEquals((Object)PlaceStatus.CLOSE, (Object)BrokenLifecycleTest.this.placeManager.getStatus(brokenScreenPlace));
                BrokenLifecycleTest.this.assertPanelDoesNotContain(BrokenLifecycleTest.this.panelManager.getRoot(), brokenScreenPlace);
                TestCase.assertTrue((boolean)BrokenLifecycleTest.this.lifecycleErrorLog.contains(BreakableScreen.class, ActivityLifecycleError.LifecyclePhase.SHUTDOWN));
            }
        });
    }

    public void assertPanelDoesNotContain(PanelDefinition panelDef, PlaceRequest place) {
        for (PartDefinition part : panelDef.getParts()) {
            if (!part.getPlace().equals(place)) continue;
            BrokenLifecycleTest.fail((String)("Found a part for " + place + " in a panel it should not have been in"));
        }
    }

    public static class LifecycleErrorLogger
    extends AbstractCDIEventCallback<ActivityLifecycleError> {
        List<ActivityLifecycleError> errors = new ArrayList<ActivityLifecycleError>();

        protected void fireEvent(ActivityLifecycleError event) {
            this.errors.add(event);
        }

        public boolean contains(Class<?> activityType, ActivityLifecycleError.LifecyclePhase failedCallback) {
            for (ActivityLifecycleError error : this.errors) {
                if (error.getFailedActivity().getClass() != activityType || error.getFailedCall() != failedCallback) continue;
                return true;
            }
            return false;
        }
    }
}

