/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.gwttest;

import com.google.common.base.Predicate;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DOM;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.marshalling.client.api.MarshallerFramework;
import org.jboss.errai.security.client.local.api.SecurityContext;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.UserCookieEncoder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.debug.Debug;
import org.uberfire.wbtest.client.menus.MenuBarTestScreen;
import org.uberfire.wbtest.gwttest.AbstractUberFireGwtTest;
import org.uberfire.wbtest.gwttest.TestingPredicates;

public class MenuAuthorizationTest
extends AbstractUberFireGwtTest {
    private PlaceManager placeManager;
    private SecurityContext securityContext;
    private static final Predicate<Void> MENU_SCREEN_NOT_VISIBLE = new Predicate<Void>(){

        public boolean apply(Void input) {
            return DOM.getElementById((String)Debug.shortName(MenuBarTestScreen.class)) == null;
        }
    };
    private User admin;

    @Override
    protected void gwtSetUp() throws Exception {
        MarshallerFramework.initializeDefaultSessionProvider();
        List<RoleImpl> roles = Arrays.asList(new RoleImpl("admin"));
        this.admin = new UserImpl("admin", roles);
        Cookies.setCookie((String)"errai-active-user", (String)UserCookieEncoder.toCookieValue((User)this.admin));
        super.gwtSetUp();
        this.placeManager = (PlaceManager)IOC.getBeanManager().lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
        this.securityContext = (SecurityContext)IOC.getBeanManager().lookupBean(SecurityContext.class, new Annotation[0]).getInstance();
    }

    public void testAdminSeesCorrectMenus() throws Exception {
        this.debugAsyncTesting = true;
        this.pollWhile(TestingPredicates.DEFAULT_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                TestCase.assertNotNull((Object)MenuAuthorizationTest.this.securityContext.getCachedUser());
                TestCase.assertEquals((Object)MenuAuthorizationTest.this.admin, (Object)MenuAuthorizationTest.this.securityContext.getCachedUser());
                MenuAuthorizationTest.this.placeManager.goTo(MenuBarTestScreen.class.getName());
            }
        }).thenPollWhile(MENU_SCREEN_NOT_VISIBLE).thenDo(new Runnable(){

            @Override
            public void run() {
                MenuAuthorizationTest.assertMenuVisible("Requires Admin");
                MenuAuthorizationTest.assertMenuVisible("Requires Either Staff Or Admin");
                MenuAuthorizationTest.assertMenuVisible("Always Visible");
                MenuAuthorizationTest.assertMenuNotVisible("Requires Staff");
            }
        });
    }

    static void assertMenuVisible(String label) {
        if (!MenuAuthorizationTest.menuVisible(DOM.getElementById((String)Debug.shortName(MenuBarTestScreen.class)), label)) {
            MenuAuthorizationTest.fail((String)("Menu with label \"" + label + "\" is not visible"));
        }
    }

    static void assertMenuNotVisible(String label) {
        if (MenuAuthorizationTest.menuVisible(DOM.getElementById((String)Debug.shortName(MenuBarTestScreen.class)), label)) {
            MenuAuthorizationTest.fail((String)("Menu with label \"" + label + "\" is visible"));
        }
    }

    private static boolean menuVisible(com.google.gwt.user.client.Element searchFrom, String label) {
        System.out.println("Looking for an <li> with text " + label);
        NodeList liElems = searchFrom.getElementsByTagName("li");
        int n = liElems.getLength();
        for (int i = 0; i < n; ++i) {
            Element item = (Element)liElems.getItem(i);
            if (item.getInnerText().contains(label)) {
                System.out.println("Found: " + item);
                return true;
            }
            System.out.println("Not this one!");
        }
        System.out.println("Not Found!");
        return false;
    }
}

