/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import org.junit.Assert;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.uberfire.workbench.model.CompassPosition;

public class UberAssertions {
    public static void assertRelativePosition(CompassPosition expected, WebElement anchor, WebElement checkMe) {
        switch (expected) {
            case NORTH: {
                if (checkMe.getLocation().y < anchor.getLocation().y) break;
                Assert.fail((String)("checkMe is not NORTH of anchor. anchor.y = " + anchor.getLocation().y + "; checkMe.y " + checkMe.getLocation().y));
                break;
            }
            case SOUTH: {
                if (checkMe.getLocation().y > anchor.getLocation().y) break;
                Assert.fail((String)("checkMe is not SOUTH of anchor. anchor.y = " + anchor.getLocation().y + "; checkMe.y " + checkMe.getLocation().y));
                break;
            }
            case EAST: {
                if (checkMe.getLocation().x > anchor.getLocation().x) break;
                Assert.fail((String)("checkMe is not EAST of anchor. anchor.x = " + anchor.getLocation().x + "; checkMe.x " + checkMe.getLocation().x));
                break;
            }
            case WEST: {
                if (checkMe.getLocation().x < anchor.getLocation().x) break;
                Assert.fail((String)("checkMe is not WEST of anchor. anchor.x = " + anchor.getLocation().x + "; checkMe.x " + checkMe.getLocation().x));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid relative position: " + expected);
            }
        }
    }

    public static void assertCentered(WebElement reference, WebElement checkMe) {
        Point referenceCenter = new Point(reference.getLocation().x + reference.getSize().width / 2, reference.getLocation().y + reference.getSize().height / 2);
        Point checkMeCenter = new Point(checkMe.getLocation().x + checkMe.getSize().width / 2, checkMe.getLocation().y + checkMe.getSize().height / 2);
        Assert.assertEquals((Object)referenceCenter, (Object)checkMeCenter);
    }
}

