/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebElement;
import org.uberfire.wbtest.client.panels.docking.NestingScreen;
import org.uberfire.wbtest.client.perspective.TabbedPerspectiveActivity;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.MultiTabPanelWrapper;

public class TabPanelTest
extends AbstractSeleniumTest {
    private MultiTabPanelWrapper tabPanel;

    @Before
    public void setup() {
        this.driver.get(this.baseUrl + "#" + TabbedPerspectiveActivity.class.getName());
        this.waitForTabbedPerspective();
        this.tabPanel = new MultiTabPanelWrapper(this.driver, "tabbedPerspectiveDefault");
        this.driver.findElement(By.cssSelector((String)"button.close")).click();
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
    }

    @Test
    public void extraTabsShouldOverflowIntoDropdownWhenCreated() throws Exception {
        this.makeOrSelectTab("one tab with long name");
        this.makeOrSelectTab("two tab with long name");
        this.makeOrSelectTab("three tab with long name");
        this.makeOrSelectTab("four tab with long name");
        this.makeOrSelectTab("five tab with long name");
        this.makeOrSelectTab("six tab with long name");
        this.makeOrSelectTab("seven tab with long name");
        this.makeOrSelectTab("eight tab with long name");
        this.makeOrSelectTab("nine tab with long name");
        this.makeOrSelectTab("ten tab with long name");
        int nonNestedTabCount = this.tabPanel.getNonNestedTabs().size();
        int nestedTabCount = this.tabPanel.getNestedTabs().size();
        System.out.println("extraTabsShouldOverflowIntoDropdown found " + nonNestedTabCount + " regular and " + nestedTabCount + " nested tabs");
        Assert.assertTrue((nestedTabCount > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)11L, (long)(nonNestedTabCount + nestedTabCount));
    }

    @Test
    public void tabDisplayShouldBeRepeatableAtAnyWindowSize() throws Exception {
        this.makeOrSelectTab("one");
        this.makeOrSelectTab("two");
        this.makeOrSelectTab("three");
        this.makeOrSelectTab("four");
        this.makeOrSelectTab("five");
        this.makeOrSelectTab("six");
        this.makeOrSelectTab("seven");
        this.makeOrSelectTab("eight");
        this.makeOrSelectTab("six");
        class WindowSizeInfo {
            int windowWidth;
            int nonNestedTabs;
            int nestedTabs;

            WindowSizeInfo() {
            }

            public String toString() {
                return "WindowSizeInfo [windowWidth=" + this.windowWidth + ", nonNestedTabs=" + this.nonNestedTabs + ", nestedTabs=" + this.nestedTabs + "]";
            }
        }
        ArrayList<WindowSizeInfo> windowSizeInfos = new ArrayList<WindowSizeInfo>();
        for (int width = 200; width <= 1000; width += 100) {
            this.driver.manage().window().setSize(new Dimension(width, 700));
            WindowSizeInfo info = new WindowSizeInfo();
            info.windowWidth = width;
            info.nonNestedTabs = this.tabPanel.getNonNestedTabs().size();
            info.nestedTabs = this.tabPanel.getNestedTabs().size();
            windowSizeInfos.add(info);
            Assert.assertEquals((Object)"six", (Object)this.tabPanel.getSelectedTabLabel());
        }
        Collections.shuffle(windowSizeInfos);
        for (WindowSizeInfo info : windowSizeInfos) {
            this.driver.manage().window().setSize(new Dimension(info.windowWidth, 700));
            Assert.assertEquals((long)info.nonNestedTabs, (long)this.tabPanel.getNonNestedTabs().size());
            Assert.assertEquals((long)info.nestedTabs, (long)this.tabPanel.getNestedTabs().size());
            Assert.assertEquals((Object)"six", (Object)this.tabPanel.getSelectedTabLabel());
        }
    }

    @Test
    public void shouldBeAbleToSelectNonNestedTab() throws Exception {
        this.makeOrSelectTab("one");
        this.makeOrSelectTab("two");
        this.makeOrSelectTab("one");
        Assert.assertEquals((long)2L, (long)this.tabPanel.getNonNestedTabs().size());
    }

    @Test
    public void shouldBeAbleToSelectNestedTab() throws Exception {
        this.makeOrSelectTab("one tab with long name");
        this.makeOrSelectTab("two tab with long name");
        this.makeOrSelectTab("three tab with long name");
        this.makeOrSelectTab("four tab with long name");
        this.makeOrSelectTab("five tab with long name");
        this.makeOrSelectTab("six tab with long name");
        this.makeOrSelectTab("seven tab with long name");
        this.makeOrSelectTab("eight tab with long name");
        this.makeOrSelectTab("nine tab with long name");
        this.makeOrSelectTab("ten tab with long name");
        this.makeOrSelectTab("eight tab with long name");
        Assert.assertTrue((boolean)this.tabPanel.getDropdownTabLabel().contains("eight tab with long name"));
        Assert.assertEquals((long)11L, (long)(this.tabPanel.getNestedTabs().size() + this.tabPanel.getNonNestedTabs().size()));
    }

    @Test
    public void nearbyTabShouldGetSelectedWhenActiveTabIsClosed() throws Exception {
        this.makeOrSelectTab("one");
        this.makeOrSelectTab("two");
        this.makeOrSelectTab("three");
        this.makeOrSelectTab("four");
        this.makeOrSelectTab("five");
        this.makeOrSelectTab("six");
        Assert.assertEquals((Object)"six", (Object)this.tabPanel.getSelectedTabLabel());
        this.tabPanel.closeSelectedTab();
        Assert.assertEquals((Object)"five", (Object)this.tabPanel.getSelectedTabLabel());
        this.makeOrSelectTab("three");
        this.tabPanel.closeSelectedTab();
        Assert.assertEquals((Object)"two", (Object)this.tabPanel.getSelectedTabLabel());
        this.makeOrSelectTab("one");
        this.tabPanel.closeSelectedTab();
        Assert.assertEquals((Object)"two", (Object)this.tabPanel.getSelectedTabLabel());
    }

    @Test
    public void selectedTabShouldStaySelectedWhenOtherTabIsClosed() throws Exception {
        this.makeOrSelectTab("one");
        this.makeOrSelectTab("two");
        this.makeOrSelectTab("three");
        this.makeOrSelectTab("four");
        this.makeOrSelectTab("three");
        this.tabPanel.closeTab("one");
        Assert.assertEquals((Object)"three", (Object)this.tabPanel.getSelectedTabLabel());
        this.tabPanel.closeTab("four");
        Assert.assertEquals((Object)"three", (Object)this.tabPanel.getSelectedTabLabel());
        this.tabPanel.closeTab("two");
        Assert.assertEquals((Object)"three", (Object)this.tabPanel.getSelectedTabLabel());
        Assert.assertEquals((long)1L, (long)this.tabPanel.getNonNestedTabs().size());
    }

    private void waitForTabbedPerspective() {
        this.driver.findElement(By.cssSelector((String)"ul.nav-tabs"));
    }

    private void makeOrSelectTab(String id) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        this.driver.get(this.baseUrl + "#" + NestingScreen.class.getName() + "?place=" + id);
        for (int i = 0; i < 100; ++i) {
            for (WebElement div : this.driver.findElements(By.cssSelector((String)"div.gwt-Label"))) {
                if (!div.getText().contains(id)) continue;
                Assert.assertTrue((boolean)div.isDisplayed());
                return;
            }
            Thread.sleep(50L);
        }
        Assert.fail((String)("Screen content for " + id + " did not appear after " + (System.currentTimeMillis() - startTime) + "ms"));
    }
}

