/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import com.github.gwtbootstrap.client.ui.NavPills;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.menu.MenusFixture;
import org.uberfire.client.workbench.widgets.menu.PartContextMenusView;
import org.uberfire.client.workbench.widgets.menu.PartContextMenusViewUnitTestWrapper;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class PartContextMenusViewTest {
    private PartContextMenusViewUnitTestWrapper partContextMenusViewUnitTestWrapper;
    private PartContextMenusView partContextMenusViewWithoutPermission;
    private NavPills menuBar;
    private Menus menuTopLevel;

    @Before
    public void setup() {
        this.menuBar = (NavPills)GWT.create(NavPills.class);
        this.menuTopLevel = MenusFixture.buildTopLevelMenu();
        this.partContextMenusViewUnitTestWrapper = new PartContextMenusViewUnitTestWrapper();
        this.partContextMenusViewUnitTestWrapper.setupMocks(this.menuBar);
        this.partContextMenusViewWithoutPermission = new PartContextMenusView(){

            boolean notHavePermissionToMakeThis(MenuItem item) {
                return true;
            }
        };
    }

    @Test
    public void simpleAddMenuItems() {
        Menus item = MenusFixture.buildMenuGroup();
        this.partContextMenusViewUnitTestWrapper.buildMenu(item);
        ((NavPills)Mockito.verify((Object)this.menuBar, (VerificationMode)Mockito.times((int)item.getItems().size()))).add((Widget)Mockito.any(Widget.class));
    }

    @Test
    public void makeItemWithoutPermissionShouldReturnNull() {
        Assert.assertNull((Object)this.partContextMenusViewWithoutPermission.makeItem((MenuItem)this.menuTopLevel.getItems().get(0)));
    }

    @Test
    public void makeMenuItemCommand() {
        PartContextMenusViewUnitTestWrapper spy = (PartContextMenusViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.partContextMenusViewUnitTestWrapper)));
        MenuItemCommand item = MenusFixture.buildMenuItemCommand();
        Widget widget = spy.makeItem((MenuItem)item);
        ((PartContextMenusViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuItemCommand((MenuItem)item);
    }

    @Test
    public void makeMenuGroup() {
        PartContextMenusViewUnitTestWrapper spy = (PartContextMenusViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.partContextMenusViewUnitTestWrapper)));
        MenuItem item = MenusFixture.buildMenuGroupItem();
        Widget widget = spy.makeItem(item);
        ((PartContextMenusViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuGroup((MenuGroup)item);
    }

    @Test
    public void otherTypesOfMenusShouldReturnNull() {
        Menus item = MenusFixture.buildTopLevelMenu();
        this.partContextMenusViewUnitTestWrapper.buildMenu(item);
        ((NavPills)Mockito.verify((Object)this.menuBar, (VerificationMode)Mockito.never())).add((Widget)Mockito.any(Widget.class));
    }
}

