/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.jboss.errai.ioc.client.container.CreationalContext;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.mvp.WorkbenchScreenActivity;

public class ActivityBeansInfoTest {
    private SyncBeanManager syncBeanManager;
    private ActivityBeansInfo activityBeansInfo;

    @Before
    public void setup() {
        this.syncBeanManager = (SyncBeanManager)Mockito.mock(SyncBeanManager.class);
        this.activityBeansInfo = new ActivityBeansInfo(){

            SyncBeanManager getBeanManager() {
                return ActivityBeansInfoTest.this.syncBeanManager;
            }
        };
    }

    @Test
    public void getAvaliableWorkbenchScreensIdsTest() {
        Mockito.when((Object)this.syncBeanManager.lookupBeans(WorkbenchScreenActivity.class)).thenReturn(this.generateBeansList());
        Assert.assertEquals((long)4L, (long)this.activityBeansInfo.getAvailableWorkbenchScreensIds().size());
        Assert.assertEquals((Object)"A", this.activityBeansInfo.getAvailableWorkbenchScreensIds().get(0));
        Assert.assertEquals((Object)"a", this.activityBeansInfo.getAvailableWorkbenchScreensIds().get(1));
        Assert.assertEquals((Object)"Z", this.activityBeansInfo.getAvailableWorkbenchScreensIds().get(2));
        Assert.assertEquals((Object)"z", this.activityBeansInfo.getAvailableWorkbenchScreensIds().get(3));
    }

    private Collection<IOCBeanDef<WorkbenchScreenActivity>> generateBeansList() {
        ArrayList<IOCBeanDef<WorkbenchScreenActivity>> beans = new ArrayList<IOCBeanDef<WorkbenchScreenActivity>>();
        beans.add(this.generateBeanDef("Z", true));
        beans.add(this.generateBeanDef("A", false));
        beans.add(this.generateBeanDef("a", false));
        beans.add(this.generateBeanDef("z", false));
        return beans;
    }

    private IOCBeanDef<WorkbenchScreenActivity> generateBeanDef(final String beanName, final boolean hasAnnotations) {
        return new IOCBeanDef<WorkbenchScreenActivity>(){

            public Class<WorkbenchScreenActivity> getType() {
                return null;
            }

            public Class<?> getBeanClass() {
                return null;
            }

            public Class<? extends Annotation> getScope() {
                return null;
            }

            public WorkbenchScreenActivity getInstance() {
                return null;
            }

            public WorkbenchScreenActivity getInstance(CreationalContext context) {
                return null;
            }

            public WorkbenchScreenActivity newInstance() {
                return null;
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> annotations = new HashSet<Annotation>();
                if (hasAnnotations) {
                    annotations.add((Annotation)new Named(){

                        public Class<? extends Annotation> annotationType() {
                            return null;
                        }

                        public String value() {
                            return "Z";
                        }
                    });
                }
                return annotations;
            }

            public boolean matches(Set<Annotation> annotations) {
                return false;
            }

            public String getName() {
                return beanName;
            }

            public boolean isConcrete() {
                return false;
            }

            public boolean isActivated() {
                return false;
            }
        };
    }
}

