/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jboss.errai.ioc.client.container.CreationalContext;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManagerImpl;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActivityManagerActivatedByTest {
    @InjectMocks
    ActivityManagerImpl activityManager;
    @Mock
    ActivityBeansCache activityBeansCache;
    @Mock
    SyncBeanManager iocManager;
    @Mock
    AuthorizationManager authzManager;
    private Activity activatedActivity;
    private final IOCBeanDef<Activity> activatedActivityBean = (IOCBeanDef)Mockito.mock(IOCBeanDef.class);
    private final IOCBeanDef<Activity> nonActivatedActivityBean = (IOCBeanDef)Mockito.mock(IOCBeanDef.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.authzManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.any(User.class))).thenReturn((Object)true);
        this.activatedActivity = (Activity)Mockito.mock(Activity.class);
        Mockito.when((Object)this.activatedActivity.getSignatureId()).thenReturn((Object)"activated activity");
        Mockito.when((Object)this.activatedActivityBean.getInstance()).thenReturn((Object)this.activatedActivity);
        Mockito.when((Object)this.activatedActivityBean.isActivated()).thenReturn((Object)true);
        Mockito.when((Object)this.nonActivatedActivityBean.isActivated()).thenReturn((Object)false);
        ArrayList<IOCBeanDef<Activity>> activityList = new ArrayList<IOCBeanDef<Activity>>();
        activityList.add(this.activatedActivityBean);
        activityList.add(this.nonActivatedActivityBean);
        Mockito.when((Object)this.iocManager.lookupBeans(Activity.class)).thenReturn(activityList);
        ActivityBeansCache activityBeansCache = this.activityBeansCache;
        activityBeansCache.getClass();
        ActivityBeansCache.ActivityAndMetaInfo activatedActivityAndMetaInfo = new ActivityBeansCache.ActivityAndMetaInfo(activityBeansCache, this.activatedActivityBean, 0, Collections.emptyList());
        Mockito.when((Object)this.activityBeansCache.getResourceActivities()).thenReturn(Collections.singletonList(activatedActivityAndMetaInfo));
        Mockito.when((Object)this.activityBeansCache.getActivity("activated activity")).thenReturn(this.activatedActivityBean);
    }

    @After
    public void runBlanketVerifications() {
        ((IOCBeanDef)Mockito.verify(this.nonActivatedActivityBean, (VerificationMode)Mockito.never())).getInstance();
        ((IOCBeanDef)Mockito.verify(this.nonActivatedActivityBean, (VerificationMode)Mockito.never())).getInstance((CreationalContext)Mockito.any(CreationalContext.class));
        ((IOCBeanDef)Mockito.verify(this.nonActivatedActivityBean, (VerificationMode)Mockito.never())).newInstance();
    }

    @Test
    public void getActivitiesByTypeShouldRespectBeanActivationStatus() throws Exception {
        Set activities = this.activityManager.getActivities(Activity.class);
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertSame((Object)this.activatedActivity, activities.iterator().next());
    }

    @Test
    public void getActivitiesForActivePlaceRequestShouldReturnActivity() throws Exception {
        Set activities = this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest("activated activity"));
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertSame((Object)this.activatedActivity, activities.iterator().next());
    }

    @Test
    public void getActivitiesForInactivePlaceRequestShouldReturnEmptySet() throws Exception {
        Set activities = this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest("non-activated activity"));
        Assert.assertEquals((long)0L, (long)activities.size());
    }

    @Test
    public void getActivityForActivePlaceRequestShouldReturnActivity() throws Exception {
        Activity activity = this.activityManager.getActivity(Activity.class, (PlaceRequest)new DefaultPlaceRequest("activated activity"));
        Assert.assertSame((Object)this.activatedActivity, (Object)activity);
    }

    @Test
    public void getActivityForInactivePlaceRequestShouldReturnNull() throws Exception {
        Activity activity = this.activityManager.getActivity(Activity.class, (PlaceRequest)new DefaultPlaceRequest("non-activated activity"));
        Assert.assertNull((Object)activity);
    }
}

