/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.mvp.AbstractWorkbenchEditorActivity;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchEditorActivityTest {
    @Mock
    private LockManager lockManager;
    @Mock
    private PlaceRequest place;
    @Mock
    private PlaceManager placeManager;

    @Test
    public void optimisticLockingDoesNotAcquireLocks() {
        EditorTestActivity activity = new EditorTestActivity(this.lockManager, this.placeManager, WorkbenchEditor.LockingStrategy.OPTIMISTIC);
        activity.onStartup(this.place);
        activity.onOpen();
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).acquireLockOnDemand();
    }

    @Test
    public void pessimisticLockingAcquiresLocks() {
        EditorTestActivity activity = new EditorTestActivity(this.lockManager, this.placeManager, WorkbenchEditor.LockingStrategy.PESSIMISTIC);
        activity.onStartup(this.place);
        activity.onOpen();
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).acquireLockOnDemand();
    }

    private class EditorTestActivity
    extends AbstractWorkbenchEditorActivity {
        private WorkbenchEditor.LockingStrategy strategy;

        public EditorTestActivity(LockManager lockManager, PlaceManager placeManager, WorkbenchEditor.LockingStrategy strategy) {
            super(placeManager);
            this.lockManager = lockManager;
            this.strategy = strategy;
        }

        public String getIdentifier() {
            return null;
        }

        public Collection<String> getRoles() {
            return null;
        }

        public String getSignatureId() {
            return null;
        }

        public Collection<String> getTraits() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public IsWidget getWidget() {
            return null;
        }

        protected WorkbenchEditor.LockingStrategy getLockingStrategy() {
            return this.strategy;
        }
    }
}

