/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.common.collect.Maps;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.WorkbenchLayoutImpl;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={DockLayoutPanel.class})
public class WorkbenchLayoutImplTest {
    private WorkbenchLayoutImpl workbenchLayout;
    private Widget widget;

    @Before
    public void setup() {
        this.workbenchLayout = new WorkbenchLayoutImpl();
        this.widget = (Widget)Mockito.mock(Widget.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{RequiresResize.class}));
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)element.getStyle()).thenReturn(Mockito.mock(Style.class));
        Mockito.when((Object)this.widget.getElement()).thenReturn((Object)element);
    }

    @Test
    public void testMaximize() {
        this.workbenchLayout.maximize(this.widget);
        ((Widget)Mockito.verify((Object)this.widget)).addStyleName("uf-maximized-panel");
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget), (VerificationMode)Mockito.never())).onResize();
    }

    @Test
    public void testExpandAnimation() {
        WorkbenchLayoutImpl.ExpandAnimation expandAnimation = new WorkbenchLayoutImpl.ExpandAnimation(this.widget, (Map)Maps.newHashMap(), (SimpleLayoutPanel)Mockito.mock(SimpleLayoutPanel.class));
        expandAnimation.onComplete();
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget))).onResize();
    }

    @Test
    public void testUnMaximize() {
        this.workbenchLayout.maximize(this.widget);
        this.workbenchLayout.unmaximize(this.widget);
        ((Widget)Mockito.verify((Object)this.widget)).addStyleName("uf-maximized-panel");
        ((Widget)Mockito.verify((Object)this.widget)).removeStyleName("uf-maximized-panel");
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget), (VerificationMode)Mockito.never())).onResize();
    }

    @Test
    public void testCollapseAnimation() {
        HashMap maximizedWidgetOriginalStyles = Maps.newHashMap();
        maximizedWidgetOriginalStyles.put(this.widget, new WorkbenchLayoutImpl.OriginalStyleInfo(this.widget));
        WorkbenchLayoutImpl.CollapseAnimation collapseAnimation = new WorkbenchLayoutImpl.CollapseAnimation(this.widget, (Map)maximizedWidgetOriginalStyles);
        collapseAnimation.onComplete();
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget))).onResize();
    }
}

