/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.HasWidgets;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanManagerImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AbstractPopupActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.ContextActivity;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceHistoryHandler;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceManagerImpl;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.UIPart;
import org.uberfire.client.mvp.WorkbenchActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.util.MockIOCBeanDef;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.client.workbench.events.NewSplashScreenActiveEvent;
import org.uberfire.client.workbench.events.PlaceLostFocusEvent;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.UnanchoredStaticWorkbenchPanelPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class PlaceManagerTest {
    @Mock
    Event<BeforeClosePlaceEvent> workbenchPartBeforeCloseEvent;
    @Mock
    Event<ClosePlaceEvent> workbenchPartCloseEvent;
    @Mock
    Event<PlaceLostFocusEvent> workbenchPartLostFocusEvent;
    @Mock
    Event<NewSplashScreenActiveEvent> newSplashScreenActiveEvent;
    @Mock
    ActivityManager activityManager;
    @Mock
    PlaceHistoryHandler placeHistoryHandler;
    @Mock
    Event<SelectPlaceEvent> selectWorkbenchPartEvent;
    @Mock
    PanelManager panelManager;
    @Mock
    PerspectiveManager perspectiveManager;
    @Mock
    WorkbenchLayout workbenchLayout;
    @Mock
    LayoutSelection layoutSelection;
    @InjectMocks
    PlaceManagerImpl placeManager;
    private final Activity notFoundActivity = (Activity)Mockito.mock(Activity.class);
    private final PlaceRequest kansas = new DefaultPlaceRequest("kansas");
    private final WorkbenchScreenActivity kansasActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
    private final PanelDefinition rootPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());

    @Before
    public void setup() {
        ((SyncBeanManagerImpl)IOC.getBeanManager()).reset();
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)Matchers.any(PlaceRequest.class))).thenReturn(Collections.singleton(this.notFoundActivity));
        ObservablePath mockObservablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        Mockito.when((Object)mockObservablePath.wrap((Path)Matchers.any(Path.class))).thenReturn((Object)mockObservablePath);
        IOC.getBeanManager().registerBean(new MockIOCBeanDef<ObservablePath, ObservablePath>(mockObservablePath, ObservablePath.class, Dependent.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), "ObservablePath", true, new Class[0]));
        Mockito.when((Object)this.activityManager.getActivities(this.kansas)).thenReturn(Collections.singleton(this.kansasActivity));
        this.setupPanelManagerMock();
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.kansasActivity.isDynamic()).thenReturn((Object)false);
        this.placeManager.goTo(this.kansas, (PanelDefinition)null);
        this.resetInjectedMocks();
        Mockito.reset((Object[])new WorkbenchScreenActivity[]{this.kansasActivity});
        Mockito.when((Object)this.kansasActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)this.kansasActivity.preferredWidth()).thenReturn((Object)123);
        Mockito.when((Object)this.kansasActivity.preferredHeight()).thenReturn((Object)456);
        ((PerspectiveManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ParameterizedCommand callback = (ParameterizedCommand)invocation.getArguments()[2];
                PerspectiveActivity perspectiveActivity = (PerspectiveActivity)invocation.getArguments()[1];
                callback.execute((Object)perspectiveActivity.getDefaultPerspectiveLayout());
                return null;
            }
        }).when((Object)this.perspectiveManager)).switchToPerspective((PlaceRequest)Matchers.any(PlaceRequest.class), (PerspectiveActivity)Matchers.any(PerspectiveActivity.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((PerspectiveManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Command callback = (Command)invocation.getArguments()[0];
                callback.execute();
                return null;
            }
        }).when((Object)this.perspectiveManager)).savePerspectiveState((Command)Matchers.any(Command.class));
    }

    private void resetInjectedMocks() {
        Mockito.reset((Object[])new Event[]{this.workbenchPartBeforeCloseEvent});
        Mockito.reset((Object[])new Event[]{this.workbenchPartCloseEvent});
        Mockito.reset((Object[])new Event[]{this.workbenchPartLostFocusEvent});
        Mockito.reset((Object[])new Event[]{this.newSplashScreenActiveEvent});
        Mockito.reset((Object[])new ActivityManager[]{this.activityManager});
        Mockito.reset((Object[])new PlaceHistoryHandler[]{this.placeHistoryHandler});
        Mockito.reset((Object[])new Event[]{this.selectWorkbenchPartEvent});
        Mockito.reset((Object[])new PanelManager[]{this.panelManager});
        Mockito.reset((Object[])new PerspectiveManager[]{this.perspectiveManager});
        Mockito.reset((Object[])new WorkbenchLayout[]{this.workbenchLayout});
        this.setupPanelManagerMock();
    }

    private void setupPanelManagerMock() {
        Mockito.when((Object)this.panelManager.getRoot()).thenReturn((Object)this.rootPanel);
        Mockito.when((Object)this.panelManager.addWorkbenchPanel((PanelDefinition)Matchers.any(PanelDefinition.class), (Position)Matchers.any(Position.class), (Integer)Matchers.any(Integer.class), (Integer)Matchers.any(Integer.class), (Integer)Matchers.any(Integer.class), (Integer)Matchers.any(Integer.class))).thenAnswer((Answer)new Answer<PanelDefinition>(){

            public PanelDefinition answer(InvocationOnMock invocation) throws Throwable {
                return (PanelDefinition)invocation.getArguments()[0];
            }
        });
    }

    @Test
    public void testPlaceManagerGetsInitializedToADefaultPlace() throws Exception {
        this.placeManager.initPlaceHistoryHandler();
        ((PlaceHistoryHandler)Mockito.verify((Object)this.placeHistoryHandler)).register((PlaceManager)Matchers.any(PlaceManager.class), (com.google.web.bindery.event.shared.EventBus)Matchers.any(EventBus.class), (PlaceRequest)Matchers.any(PlaceRequest.class));
    }

    @Test
    public void testGoToConditionalPlaceById() throws Exception {
        PlaceRequest dora = new ConditionalPlaceRequest("dora").when(p -> true).orElse((PlaceRequest)new DefaultPlaceRequest("other"));
        WorkbenchScreenActivity doraActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)doraActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities(dora)).thenReturn(Collections.singleton(doraActivity));
        this.placeManager.goTo(dora);
        this.verifyActivityLaunchSideEffects(dora, (WorkbenchActivity)doraActivity, null);
    }

    @Test
    public void testGoToConditionalPlaceByIdOrElse() throws Exception {
        DefaultPlaceRequest other = new DefaultPlaceRequest("other");
        PlaceRequest dora = new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)other);
        WorkbenchScreenActivity doraActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        WorkbenchScreenActivity otherActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)doraActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)otherActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities(dora)).thenReturn(Collections.singleton(doraActivity));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)other)).thenReturn(Collections.singleton(otherActivity));
        this.placeManager.goTo(dora);
        ((WorkbenchScreenActivity)Mockito.verify((Object)doraActivity, (VerificationMode)Mockito.never())).onOpen();
        ((WorkbenchScreenActivity)Mockito.verify((Object)otherActivity)).onOpen();
        this.verifyActivityLaunchSideEffects((PlaceRequest)other, (WorkbenchActivity)otherActivity, null);
    }

    @Test
    public void testGoToNewPlaceById() throws Exception {
        DefaultPlaceRequest oz = new DefaultPlaceRequest("oz");
        WorkbenchScreenActivity ozActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)ozActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)ozActivity.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)ozActivity.preferredWidth()).thenReturn((Object)-1);
        Mockito.when((Object)ozActivity.preferredHeight()).thenReturn((Object)-1);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)oz)).thenReturn(Collections.singleton(ozActivity));
        this.placeManager.goTo((PlaceRequest)oz, (PanelDefinition)null);
        this.verifyActivityLaunchSideEffects((PlaceRequest)oz, (WorkbenchActivity)ozActivity, null);
    }

    @Test
    public void testGoToPlaceWeAreAlreadyAt() throws Exception {
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo(this.kansas, (PanelDefinition)null);
        ((Event)Mockito.verify(this.selectWorkbenchPartEvent)).fire(Matchers.refEq((Object)new SelectPlaceEvent(this.kansas), (String[])new String[0]));
        this.verifyNoActivityLaunchSideEffects(this.kansas, this.kansasActivity);
    }

    @Test
    public void testGoToNowhereDoesNothing() throws Exception {
        this.placeManager.goTo(PlaceRequest.NOWHERE, (PanelDefinition)null);
        this.verifyNoActivityLaunchSideEffects(this.kansas, this.kansasActivity);
    }

    @Test
    public void testGoToNullDoesNothing() throws Exception {
        this.placeManager.goTo((PlaceRequest)null, (PanelDefinition)null);
        this.verifyNoActivityLaunchSideEffects(this.kansas, this.kansasActivity);
    }

    @Test
    public void testGoToPlaceByPath() throws Exception {
        FakePathPlaceRequest yellowBrickRoad = new FakePathPlaceRequest((ObservablePath)Mockito.mock(ObservablePath.class));
        WorkbenchScreenActivity ozActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)ozActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)yellowBrickRoad)).thenReturn(Collections.singleton(ozActivity));
        this.placeManager.goTo((PlaceRequest)yellowBrickRoad, (PanelDefinition)null);
        this.verifyActivityLaunchSideEffects((PlaceRequest)yellowBrickRoad, (WorkbenchActivity)ozActivity, null);
        ((ObservablePath)Mockito.verify((Object)yellowBrickRoad.getPath(), (VerificationMode)Mockito.never())).onDelete((Command)Matchers.any(Command.class));
    }

    @Test
    public void testNormalCloseExistingScreenActivity() throws Exception {
        Mockito.when((Object)this.kansasActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.closePlace(this.kansas);
        ((Event)Mockito.verify(this.workbenchPartBeforeCloseEvent)).fire(Matchers.refEq((Object)new BeforeClosePlaceEvent(this.kansas, false, true), (String[])new String[0]));
        ((Event)Mockito.verify(this.workbenchPartCloseEvent)).fire(Matchers.refEq((Object)new ClosePlaceEvent(this.kansas), (String[])new String[0]));
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity)).onMayClose();
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity)).onClose();
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.never())).onShutdown();
        ((ActivityManager)Mockito.verify((Object)this.activityManager)).destroyActivity((Activity)this.kansasActivity);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removePartForPlace(this.kansas);
        Assert.assertEquals((Object)PlaceStatus.CLOSE, (Object)this.placeManager.getStatus(this.kansas));
        Assert.assertNull((Object)this.placeManager.getActivity(this.kansas));
        Assert.assertFalse((boolean)this.placeManager.getActivePlaceRequests().contains(this.kansas));
    }

    @Test
    public void testCanceledCloseExistingScreenActivity() throws Exception {
        Mockito.when((Object)this.kansasActivity.onMayClose()).thenReturn((Object)false);
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.closePlace(this.kansas);
        ((Event)Mockito.verify(this.workbenchPartBeforeCloseEvent)).fire(Matchers.refEq((Object)new BeforeClosePlaceEvent(this.kansas, false, true), (String[])new String[0]));
        ((Event)Mockito.verify(this.workbenchPartCloseEvent, (VerificationMode)Mockito.never())).fire(Matchers.refEq((Object)new ClosePlaceEvent(this.kansas), (String[])new String[0]));
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity)).onMayClose();
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.never())).onClose();
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.never())).onShutdown();
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.never())).destroyActivity((Activity)this.kansasActivity);
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).removePartForPlace(this.kansas);
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus(this.kansas));
        Assert.assertSame((Object)this.kansasActivity, (Object)this.placeManager.getActivity(this.kansas));
        Assert.assertTrue((boolean)this.placeManager.getActivePlaceRequests().contains(this.kansas));
    }

    @Test
    public void testForceCloseExistingScreenActivity() throws Exception {
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.forceClosePlace(this.kansas);
        ((Event)Mockito.verify(this.workbenchPartBeforeCloseEvent)).fire(Matchers.refEq((Object)new BeforeClosePlaceEvent(this.kansas, true, true), (String[])new String[0]));
        ((Event)Mockito.verify(this.workbenchPartCloseEvent)).fire(Matchers.refEq((Object)new ClosePlaceEvent(this.kansas), (String[])new String[0]));
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.never())).onMayClose();
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity)).onClose();
        ((WorkbenchScreenActivity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.never())).onShutdown();
        ((ActivityManager)Mockito.verify((Object)this.activityManager)).destroyActivity((Activity)this.kansasActivity);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removePartForPlace(this.kansas);
        Assert.assertEquals((Object)PlaceStatus.CLOSE, (Object)this.placeManager.getStatus(this.kansas));
        Assert.assertNull((Object)this.placeManager.getActivity(this.kansas));
        Assert.assertFalse((boolean)this.placeManager.getActivePlaceRequests().contains(this.kansas));
    }

    @Test
    public void testLaunchingEmptyPerspective() throws Exception {
        PerspectiveActivity ozPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        DefaultPlaceRequest ozPerspectivePlace = new DefaultPlaceRequest("oz_perspective");
        PerspectiveDefinitionImpl ozPerspectiveDef = new PerspectiveDefinitionImpl();
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)ozPerspectivePlace)).thenReturn(Collections.singleton(ozPerspectiveActivity));
        Mockito.when((Object)ozPerspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)ozPerspectiveDef);
        Mockito.when((Object)ozPerspectiveActivity.getPlace()).thenReturn((Object)ozPerspectivePlace);
        Mockito.when((Object)ozPerspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)ozPerspectivePlace);
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager)).savePerspectiveState((Command)Matchers.any(Command.class));
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager)).switchToPerspective((PlaceRequest)Matchers.any(PlaceRequest.class), (PerspectiveActivity)Matchers.eq((Object)ozPerspectiveActivity), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        ((PerspectiveActivity)Mockito.verify((Object)ozPerspectiveActivity)).onOpen();
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)ozPerspectivePlace));
        Assert.assertTrue((boolean)this.placeManager.getActivePlaceRequests().contains(ozPerspectivePlace));
        Assert.assertEquals((Object)ozPerspectiveActivity, (Object)this.placeManager.getActivity((PlaceRequest)ozPerspectivePlace));
        ((WorkbenchLayout)Mockito.verify((Object)this.workbenchLayout)).onResize();
    }

    @Test
    public void testSwitchingPerspectives() throws Exception {
        PerspectiveActivity ozPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        DefaultPlaceRequest ozPerspectivePlace = new DefaultPlaceRequest("oz_perspective");
        PerspectiveDefinitionImpl ozPerspectiveDef = new PerspectiveDefinitionImpl();
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)ozPerspectivePlace)).thenReturn(Collections.singleton(ozPerspectiveActivity));
        Mockito.when((Object)ozPerspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)ozPerspectiveDef);
        Mockito.when((Object)ozPerspectiveActivity.getPlace()).thenReturn((Object)ozPerspectivePlace);
        Mockito.when((Object)ozPerspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        PerspectiveActivity kansasPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)kansasPerspectiveActivity);
        this.placeManager.goTo((PlaceRequest)ozPerspectivePlace);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.activityManager, kansasPerspectiveActivity, this.kansasActivity, this.workbenchLayout});
        ((WorkbenchScreenActivity)inOrder.verify((Object)this.kansasActivity)).onClose();
        ((ActivityManager)inOrder.verify((Object)this.activityManager)).destroyActivity((Activity)this.kansasActivity);
        ((PerspectiveActivity)inOrder.verify((Object)kansasPerspectiveActivity)).onClose();
        ((ActivityManager)inOrder.verify((Object)this.activityManager)).destroyActivity((Activity)kansasPerspectiveActivity);
        ((WorkbenchLayout)inOrder.verify((Object)this.workbenchLayout)).onResize();
    }

    @Test
    public void testSwitchingFromPerspectiveToSelf() throws Exception {
        PerspectiveActivity ozPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        DefaultPlaceRequest ozPerspectivePlace = new DefaultPlaceRequest("oz_perspective");
        PerspectiveDefinitionImpl ozPerspectiveDef = new PerspectiveDefinitionImpl();
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)ozPerspectivePlace)).thenReturn(Collections.singleton(ozPerspectiveActivity));
        Mockito.when((Object)ozPerspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)ozPerspectiveDef);
        Mockito.when((Object)ozPerspectiveActivity.getPlace()).thenReturn((Object)ozPerspectivePlace);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)ozPerspectiveActivity);
        this.placeManager.goTo((PlaceRequest)ozPerspectivePlace);
        ((PerspectiveActivity)Mockito.verify((Object)ozPerspectiveActivity, (VerificationMode)Mockito.never())).onOpen();
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager, (VerificationMode)Mockito.never())).savePerspectiveState((Command)Matchers.any(Command.class));
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager, (VerificationMode)Mockito.never())).switchToPerspective((PlaceRequest)Matchers.any(PlaceRequest.class), (PerspectiveActivity)Matchers.any(PerspectiveActivity.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void testLaunchingActivityTiedToDifferentPerspective() throws Exception {
        PerspectiveActivity ozPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        DefaultPlaceRequest ozPerspectivePlace = new DefaultPlaceRequest("oz_perspective");
        PerspectiveDefinitionImpl ozPerspectiveDef = new PerspectiveDefinitionImpl();
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)ozPerspectivePlace)).thenReturn(Collections.singleton(ozPerspectiveActivity));
        Mockito.when((Object)ozPerspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)ozPerspectiveDef);
        Mockito.when((Object)ozPerspectiveActivity.getPlace()).thenReturn((Object)ozPerspectivePlace);
        Mockito.when((Object)ozPerspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        DefaultPlaceRequest emeraldCityPlace = new DefaultPlaceRequest("emerald_city");
        WorkbenchScreenActivity emeraldCityActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)emeraldCityPlace)).thenReturn(Collections.singleton(emeraldCityActivity));
        Mockito.when((Object)emeraldCityActivity.getOwningPlace()).thenReturn((Object)ozPerspectivePlace);
        Mockito.when((Object)emeraldCityActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)emeraldCityPlace, (PanelDefinition)null);
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager)).savePerspectiveState((Command)Matchers.any(Command.class));
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager)).switchToPerspective((PlaceRequest)Matchers.any(PlaceRequest.class), (PerspectiveActivity)Matchers.eq((Object)ozPerspectiveActivity), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)ozPerspectivePlace));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ozPerspectiveActivity, emeraldCityActivity});
        ((PerspectiveActivity)inOrder.verify((Object)ozPerspectiveActivity)).onOpen();
        ((WorkbenchScreenActivity)inOrder.verify((Object)emeraldCityActivity)).onOpen();
        this.verifyActivityLaunchSideEffects((PlaceRequest)emeraldCityPlace, (WorkbenchActivity)emeraldCityActivity, null);
    }

    @Test
    public void testPerspectiveLaunchWithSplashScreen() throws Exception {
        DefaultPlaceRequest perspectivePlace = new DefaultPlaceRequest("Somewhere");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveDefinitionImpl perspectiveDef = new PerspectiveDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        Mockito.when((Object)perspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)perspectiveDef);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)perspectivePlace)).thenReturn(Collections.singleton(perspectiveActivity));
        SplashScreenActivity splashScreenActivity = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)this.activityManager.getSplashScreenInterceptor((PlaceRequest)perspectivePlace)).thenReturn((Object)splashScreenActivity);
        Mockito.when((Object)perspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)splashScreenActivity.isType(ActivityResourceType.SPLASH.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)perspectivePlace);
        ((SplashScreenActivity)Mockito.verify((Object)splashScreenActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{splashScreenActivity, this.newSplashScreenActiveEvent});
        ((SplashScreenActivity)inOrder.verify((Object)splashScreenActivity)).onOpen();
        ((Event)inOrder.verify(this.newSplashScreenActiveEvent)).fire(Matchers.any(NewSplashScreenActiveEvent.class));
        Assert.assertTrue((boolean)this.placeManager.getActiveSplashScreens().contains(splashScreenActivity));
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((PerspectiveActivity)Mockito.verify((Object)perspectiveActivity)).onOpen();
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)perspectivePlace));
        Assert.assertSame((Object)perspectiveActivity, (Object)this.placeManager.getActivity((PlaceRequest)perspectivePlace));
    }

    @Test
    public void testProperSplashScreenShutdownOnPerspectiveSwitch() throws Exception {
        DefaultPlaceRequest perspectivePlace = new DefaultPlaceRequest("Somewhere");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveDefinitionImpl perspectiveDef = new PerspectiveDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        Mockito.when((Object)perspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)perspectiveDef);
        Mockito.when((Object)perspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)perspectivePlace)).thenReturn(Collections.singleton(perspectiveActivity));
        SplashScreenActivity splashScreenActivity1 = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)this.activityManager.getSplashScreenInterceptor((PlaceRequest)perspectivePlace)).thenReturn((Object)splashScreenActivity1);
        Mockito.when((Object)splashScreenActivity1.isType(ActivityResourceType.SPLASH.name())).thenReturn((Object)true);
        SplashScreenActivity splashScreenActivity2 = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)this.activityManager.getSplashScreenInterceptor(this.kansas)).thenReturn((Object)splashScreenActivity2);
        Mockito.when((Object)this.activityManager.getActivities(this.kansas)).thenReturn(Collections.singleton(this.kansasActivity));
        Mockito.when((Object)splashScreenActivity2.isType(ActivityResourceType.SPLASH.name())).thenReturn((Object)true);
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)perspectivePlace);
        this.placeManager.goTo(this.kansas);
        Assert.assertTrue((boolean)this.placeManager.getActiveSplashScreens().contains(splashScreenActivity1));
        Assert.assertTrue((boolean)this.placeManager.getActiveSplashScreens().contains(splashScreenActivity2));
        DefaultPlaceRequest otherPerspectivePlace = new DefaultPlaceRequest("Elsewhere");
        PerspectiveActivity otherPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveDefinitionImpl otherPerspectiveDef = new PerspectiveDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        Mockito.when((Object)otherPerspectiveActivity.getDefaultPerspectiveLayout()).thenReturn((Object)otherPerspectiveDef);
        Mockito.when((Object)otherPerspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)otherPerspectivePlace)).thenReturn(Collections.singleton(otherPerspectiveActivity));
        this.placeManager.goTo((PlaceRequest)otherPerspectivePlace);
        Assert.assertTrue((boolean)this.placeManager.getActiveSplashScreens().isEmpty());
        ((SplashScreenActivity)Mockito.verify((Object)splashScreenActivity1)).closeIfOpen();
        ((SplashScreenActivity)Mockito.verify((Object)splashScreenActivity2)).closeIfOpen();
        ((ActivityManager)Mockito.verify((Object)this.activityManager)).destroyActivity((Activity)splashScreenActivity1);
        ((ActivityManager)Mockito.verify((Object)this.activityManager)).destroyActivity((Activity)splashScreenActivity2);
    }

    @Test
    public void testPartLaunchWithSplashScreen() throws Exception {
        DefaultPlaceRequest oz = new DefaultPlaceRequest("oz");
        WorkbenchScreenActivity ozActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)oz)).thenReturn(Collections.singleton(ozActivity));
        Mockito.when((Object)ozActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        SplashScreenActivity lollipopGuildActivity = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)this.activityManager.getSplashScreenInterceptor((PlaceRequest)oz)).thenReturn((Object)lollipopGuildActivity);
        Mockito.when((Object)lollipopGuildActivity.isType(ActivityResourceType.SPLASH.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)oz, (PanelDefinition)null);
        Assert.assertTrue((boolean)this.placeManager.getActiveSplashScreens().contains(lollipopGuildActivity));
        ((SplashScreenActivity)Mockito.verify((Object)lollipopGuildActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{lollipopGuildActivity, this.newSplashScreenActiveEvent});
        ((SplashScreenActivity)inOrder.verify((Object)lollipopGuildActivity)).onOpen();
        ((Event)inOrder.verify(this.newSplashScreenActiveEvent)).fire(Matchers.any(NewSplashScreenActiveEvent.class));
    }

    @Test
    public void testProperSplashScreenShutdownOnPartClose() throws Exception {
        DefaultPlaceRequest oz = new DefaultPlaceRequest("oz");
        WorkbenchScreenActivity ozActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)oz)).thenReturn(Collections.singleton(ozActivity));
        SplashScreenActivity lollipopGuildActivity = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)lollipopGuildActivity.isType(ActivityResourceType.SPLASH.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getSplashScreenInterceptor((PlaceRequest)oz)).thenReturn((Object)lollipopGuildActivity);
        Mockito.when((Object)ozActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)oz, (PanelDefinition)null);
        this.placeManager.closePlace((PlaceRequest)oz);
        Assert.assertTrue((boolean)this.placeManager.getActiveSplashScreens().isEmpty());
        ((SplashScreenActivity)Mockito.verify((Object)lollipopGuildActivity)).closeIfOpen();
        ((ActivityManager)Mockito.verify((Object)this.activityManager)).destroyActivity((Activity)lollipopGuildActivity);
    }

    @Test
    public void testSplashScreenActivityShouldNotLaunchOnItsOwn() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        SplashScreenActivity splashScreenActivity = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn(Collections.singleton(splashScreenActivity));
        this.placeManager.goTo((PlaceRequest)somewhere);
        ((SplashScreenActivity)Mockito.verify((Object)splashScreenActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.eq((Object)somewhere));
        ((SplashScreenActivity)Mockito.verify((Object)splashScreenActivity, (VerificationMode)Mockito.never())).onOpen();
        ((Event)Mockito.verify(this.newSplashScreenActiveEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(NewSplashScreenActiveEvent.class));
        Assert.assertFalse((boolean)this.placeManager.getActiveSplashScreens().contains(splashScreenActivity));
    }

    @Test
    public void testContextActivityShouldNotLaunchOnItsOwn() throws Exception {
        DefaultPlaceRequest somewhere = new DefaultPlaceRequest("Somewhere");
        ContextActivity activity = (ContextActivity)Mockito.mock(ContextActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn(Collections.singleton(activity));
        this.placeManager.goTo((PlaceRequest)somewhere);
        ((ContextActivity)Mockito.verify((Object)activity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.eq((Object)somewhere));
        ((ContextActivity)Mockito.verify((Object)activity, (VerificationMode)Mockito.never())).onOpen();
    }

    @Test
    public void testLaunchingPopup() throws Exception {
        DefaultPlaceRequest popupPlace = new DefaultPlaceRequest("Somewhere");
        AbstractPopupActivity popupActivity = (AbstractPopupActivity)Mockito.mock(AbstractPopupActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)popupPlace)).thenReturn(Collections.singleton(popupActivity));
        Mockito.when((Object)popupActivity.isType(ActivityResourceType.POPUP.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)popupPlace);
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((PlaceHistoryHandler)Mockito.verify((Object)this.placeHistoryHandler, (VerificationMode)Mockito.times((int)1))).onPlaceChange((PlaceRequest)popupPlace);
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)popupPlace));
    }

    @Test
    public void testLaunchingPopupThatIsAlreadyOpen() throws Exception {
        DefaultPlaceRequest popupPlace = new DefaultPlaceRequest("Somewhere");
        AbstractPopupActivity popupActivity = (AbstractPopupActivity)Mockito.mock(AbstractPopupActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)popupPlace)).thenReturn(Collections.singleton(popupActivity));
        Mockito.when((Object)popupActivity.isType(ActivityResourceType.POPUP.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)popupPlace);
        this.placeManager.goTo((PlaceRequest)popupPlace);
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((PlaceHistoryHandler)Mockito.verify((Object)this.placeHistoryHandler, (VerificationMode)Mockito.times((int)1))).onPlaceChange((PlaceRequest)popupPlace);
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)popupPlace));
    }

    @Test
    public void testReLaunchingClosedPopup() throws Exception {
        DefaultPlaceRequest popupPlace = new DefaultPlaceRequest("Somewhere");
        AbstractPopupActivity popupActivity = (AbstractPopupActivity)Mockito.mock(AbstractPopupActivity.class);
        Mockito.when((Object)popupActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)popupActivity.isType(ActivityResourceType.POPUP.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)popupPlace)).thenReturn(Collections.singleton(popupActivity));
        this.placeManager.goTo((PlaceRequest)popupPlace);
        this.placeManager.closePlace((PlaceRequest)popupPlace);
        this.placeManager.goTo((PlaceRequest)popupPlace);
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.times((int)2))).onOpen();
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.times((int)1))).onClose();
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)popupPlace));
    }

    @Test
    public void testPopupCancelsClose() throws Exception {
        DefaultPlaceRequest popupPlace = new DefaultPlaceRequest("Somewhere");
        AbstractPopupActivity popupActivity = (AbstractPopupActivity)Mockito.mock(AbstractPopupActivity.class);
        Mockito.when((Object)popupActivity.onMayClose()).thenReturn((Object)false);
        Mockito.when((Object)popupActivity.isType(ActivityResourceType.POPUP.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)popupPlace)).thenReturn(Collections.singleton(popupActivity));
        this.placeManager.goTo((PlaceRequest)popupPlace);
        this.placeManager.closePlace((PlaceRequest)popupPlace);
        ((AbstractPopupActivity)Mockito.verify((Object)popupActivity, (VerificationMode)Mockito.never())).onClose();
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus((PlaceRequest)popupPlace));
    }

    @Test
    public void testLaunchActivityInCustomPanel() throws Exception {
        PanelDefinitionImpl customPanelDef = new PanelDefinitionImpl(UnanchoredStaticWorkbenchPanelPresenter.class.getName());
        Mockito.when((Object)this.panelManager.addCustomPanel((HasWidgets)Matchers.any(HasWidgets.class), (String)Matchers.eq((Object)UnanchoredStaticWorkbenchPanelPresenter.class.getName()))).thenReturn((Object)customPanelDef);
        DefaultPlaceRequest emeraldCityPlace = new DefaultPlaceRequest("emerald_city");
        WorkbenchScreenActivity emeraldCityActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)emeraldCityActivity.preferredWidth()).thenReturn((Object)555);
        Mockito.when((Object)emeraldCityActivity.preferredHeight()).thenReturn((Object)-1);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)emeraldCityPlace)).thenReturn(Collections.singleton(emeraldCityActivity));
        Mockito.when((Object)emeraldCityActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        HasWidgets customContainer = (HasWidgets)Mockito.mock(HasWidgets.class);
        this.placeManager.goTo((PlaceRequest)emeraldCityPlace, customContainer);
        this.verifyActivityLaunchSideEffects((PlaceRequest)emeraldCityPlace, (WorkbenchActivity)emeraldCityActivity, (PanelDefinition)customPanelDef);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPart((PlaceRequest)Matchers.eq((Object)emeraldCityPlace), (PartDefinition)Matchers.eq((Object)new PartDefinitionImpl((PlaceRequest)emeraldCityPlace)), (PanelDefinition)Matchers.eq((Object)customPanelDef), (Menus)Matchers.isNull(Menus.class), (UIPart)Matchers.any(UIPart.class), (String)Matchers.isNull(String.class), (Integer)Matchers.isNull(Integer.class), (Integer)Matchers.isNull(Integer.class));
        Assert.assertNull((Object)customPanelDef.getParent());
    }

    @Test
    public void testLaunchExistingActivityInCustomPanel() throws Exception {
        HasWidgets customContainer = (HasWidgets)Mockito.mock(HasWidgets.class);
        Mockito.when((Object)this.kansasActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo(this.kansas, customContainer);
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).addCustomPanel(customContainer, StaticWorkbenchPanelPresenter.class.getName());
        this.verifyNoActivityLaunchSideEffects(this.kansas, this.kansasActivity);
        ((Event)Mockito.verify(this.selectWorkbenchPartEvent)).fire(Matchers.refEq((Object)new SelectPlaceEvent(this.kansas), (String[])new String[0]));
    }

    @Test
    public void testClosingActivityInCustomPanel() throws Exception {
        PanelDefinitionImpl customPanelDef = new PanelDefinitionImpl(UnanchoredStaticWorkbenchPanelPresenter.class.getName());
        Mockito.when((Object)this.panelManager.addCustomPanel((HasWidgets)Matchers.any(HasWidgets.class), (String)Matchers.eq((Object)UnanchoredStaticWorkbenchPanelPresenter.class.getName()))).thenReturn((Object)customPanelDef);
        DefaultPlaceRequest emeraldCityPlace = new DefaultPlaceRequest("emerald_city");
        WorkbenchScreenActivity emeraldCityActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)emeraldCityActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)emeraldCityActivity.preferredWidth()).thenReturn((Object)555);
        Mockito.when((Object)emeraldCityActivity.preferredHeight()).thenReturn((Object)-1);
        Mockito.when((Object)emeraldCityActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)emeraldCityPlace)).thenReturn(Collections.singleton(emeraldCityActivity));
        HasWidgets customContainer = (HasWidgets)Mockito.mock(HasWidgets.class);
        this.placeManager.goTo((PlaceRequest)emeraldCityPlace, customContainer);
        this.placeManager.closePlace((PlaceRequest)emeraldCityPlace);
        Assert.assertTrue((boolean)customPanelDef.getParts().isEmpty());
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)customPanelDef);
    }

    @Test
    public void testClosingAllPlacesIncludesCustomPanels() throws Exception {
        PanelDefinitionImpl customPanelDef = new PanelDefinitionImpl(UnanchoredStaticWorkbenchPanelPresenter.class.getName());
        Mockito.when((Object)this.panelManager.addCustomPanel((HasWidgets)Matchers.any(HasWidgets.class), (String)Matchers.eq((Object)UnanchoredStaticWorkbenchPanelPresenter.class.getName()))).thenReturn((Object)customPanelDef);
        DefaultPlaceRequest emeraldCityPlace = new DefaultPlaceRequest("emerald_city");
        WorkbenchScreenActivity emeraldCityActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)emeraldCityActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)emeraldCityActivity.preferredWidth()).thenReturn((Object)555);
        Mockito.when((Object)emeraldCityActivity.preferredHeight()).thenReturn((Object)-1);
        Mockito.when((Object)emeraldCityActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)emeraldCityPlace)).thenReturn(Collections.singleton(emeraldCityActivity));
        HasWidgets customContainer = (HasWidgets)Mockito.mock(HasWidgets.class);
        this.placeManager.goTo((PlaceRequest)emeraldCityPlace, customContainer);
        this.placeManager.closeAllPlaces();
        Assert.assertTrue((boolean)customPanelDef.getParts().isEmpty());
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)customPanelDef);
    }

    @Test
    public void testGetActivitiesForResourceType_NoMatches() throws Exception {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        FakePathPlaceRequest yellowBrickRoad = new FakePathPlaceRequest(path);
        WorkbenchScreenActivity ozActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)yellowBrickRoad)).thenReturn(Collections.singleton(ozActivity));
        Mockito.when((Object)ozActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)yellowBrickRoad);
        this.verifyActivityLaunchSideEffects((PlaceRequest)yellowBrickRoad, (WorkbenchActivity)ozActivity, null);
        ResourceTypeDefinition resourceType = (ResourceTypeDefinition)Mockito.mock(ResourceTypeDefinition.class);
        Mockito.when((Object)resourceType.accept((Path)path)).thenReturn((Object)false);
        Collection resolvedActivities = this.placeManager.getActivitiesForResourceType(resourceType);
        Assert.assertNotNull((Object)resolvedActivities);
        Assert.assertEquals((long)0L, (long)resolvedActivities.size());
    }

    @Test
    public void testGetActivitiesForResourceType_Matches() throws Exception {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        FakePathPlaceRequest yellowBrickRoad = new FakePathPlaceRequest(path);
        WorkbenchScreenActivity ozActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)yellowBrickRoad)).thenReturn(Collections.singleton(ozActivity));
        Mockito.when((Object)ozActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        this.placeManager.goTo((PlaceRequest)yellowBrickRoad);
        this.verifyActivityLaunchSideEffects((PlaceRequest)yellowBrickRoad, (WorkbenchActivity)ozActivity, null);
        ResourceTypeDefinition resourceType = (ResourceTypeDefinition)Mockito.mock(ResourceTypeDefinition.class);
        Mockito.when((Object)resourceType.accept((Path)path)).thenReturn((Object)true);
        Collection resolvedActivities = this.placeManager.getActivitiesForResourceType(resourceType);
        Assert.assertNotNull((Object)resolvedActivities);
        Assert.assertEquals((long)1L, (long)resolvedActivities.size());
        try {
            resolvedActivities.clear();
            Assert.fail((String)"PlaceManager.getActivitiesForResourceType() should return an unmodifiable collection.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void verifyActivityLaunchSideEffects(PlaceRequest placeRequest, WorkbenchActivity activity, PanelDefinition expectedPanel) {
        Integer expectedPartHeight;
        Integer expectedPartWidth;
        ((Event)Mockito.verify(this.selectWorkbenchPartEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(SelectPlaceEvent.class));
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).getActivities(placeRequest);
        Integer preferredWidth = activity.preferredWidth();
        Integer preferredHeight = activity.preferredHeight();
        if (expectedPanel == null) {
            PanelDefinition rootPanel = this.panelManager.getRoot();
            ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(rootPanel, null, preferredHeight, preferredWidth, null, null);
            expectedPartWidth = null;
            expectedPartHeight = null;
        } else {
            expectedPartWidth = expectedPanel.getWidth();
            expectedPartHeight = expectedPanel.getHeight();
        }
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPart((PlaceRequest)Matchers.eq((Object)placeRequest), (PartDefinition)Matchers.eq((Object)new PartDefinitionImpl(placeRequest)), expectedPanel == null ? (PanelDefinition)Matchers.any(PanelDefinition.class) : (PanelDefinition)Matchers.eq((Object)expectedPanel), (Menus)Matchers.isNull(Menus.class), (UIPart)Matchers.any(UIPart.class), (String)Matchers.isNull(String.class), (Integer)Matchers.eq((Object)expectedPartWidth), (Integer)Matchers.eq((Object)expectedPartHeight));
        ((PlaceHistoryHandler)Mockito.verify((Object)this.placeHistoryHandler)).onPlaceChange(placeRequest);
        Assert.assertTrue((String)("Actual place requests: " + this.placeManager.getActivePlaceRequests()), (boolean)this.placeManager.getActivePlaceRequests().contains(placeRequest));
        Assert.assertSame((Object)activity, (Object)this.placeManager.getActivity(placeRequest));
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus(placeRequest));
        ((WorkbenchActivity)Mockito.verify((Object)activity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((WorkbenchActivity)Mockito.verify((Object)activity, (VerificationMode)Mockito.times((int)1))).onOpen();
    }

    private void verifyNoActivityLaunchSideEffects(PlaceRequest expectedCurrentPlace, WorkbenchScreenActivity activity) {
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).addWorkbenchPanel((PanelDefinition)Matchers.eq((Object)this.panelManager.getRoot()), (Position)Matchers.any(Position.class), (Integer)Matchers.any(Integer.class), (Integer)Matchers.any(Integer.class), (Integer)Matchers.any(Integer.class), (Integer)Matchers.any(Integer.class));
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).addWorkbenchPanel((PanelDefinition)Matchers.eq((Object)this.panelManager.getRoot()), (PanelDefinition)Matchers.any(PanelDefinition.class), (Position)Matchers.any(Position.class));
        ((PlaceHistoryHandler)Mockito.verify((Object)this.placeHistoryHandler, (VerificationMode)Mockito.never())).onPlaceChange((PlaceRequest)Matchers.any(PlaceRequest.class));
        Assert.assertTrue((String)("Actual place requests: " + this.placeManager.getActivePlaceRequests()), (boolean)this.placeManager.getActivePlaceRequests().contains(expectedCurrentPlace));
        Assert.assertSame((Object)activity, (Object)this.placeManager.getActivity(expectedCurrentPlace));
        Assert.assertEquals((Object)PlaceStatus.OPEN, (Object)this.placeManager.getStatus(expectedCurrentPlace));
        ((WorkbenchScreenActivity)Mockito.verify((Object)activity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((WorkbenchScreenActivity)Mockito.verify((Object)activity, (VerificationMode)Mockito.never())).onOpen();
    }

    class FakePathPlaceRequest
    extends PathPlaceRequest {
        final ObservablePath path;

        FakePathPlaceRequest(ObservablePath path) {
            this.path = path;
        }

        public ObservablePath getPath() {
            return this.path;
        }

        public int hashCode() {
            return 42;
        }
    }
}

