/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractSimpleWorkbenchPanelViewTest;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelViewUnitTestWrapper;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SimpleWorkbenchPanelViewTest
extends AbstractSimpleWorkbenchPanelViewTest {
    @InjectMocks
    private SimpleWorkbenchPanelViewUnitTestWrapper view;
    private SimpleWorkbenchPanelPresenter presenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = (SimpleWorkbenchPanelPresenter)Mockito.mock(SimpleWorkbenchPanelPresenter.class);
        this.view.setup();
        this.view.init((WorkbenchPanelPresenter)this.presenter);
    }

    @Override
    protected AbstractDockingWorkbenchPanelView<?> getViewToTest() {
        return this.view;
    }

    @Test
    public void shouldAddPresenterOnInit() {
        Assert.assertEquals((Object)this.presenter, (Object)this.view.getPresenter());
    }

    @Test
    public void shouldSetupDragAndDropOnListBar() {
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).setDndManager((WorkbenchDragAndDropManager)Matchers.eq((Object)this.dndManager));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).disableDnd();
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Matchers.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Matchers.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addOnFocusHandler((Command)Matchers.any(Command.class));
    }

    @Test
    public void shouldPropagateResizeWhenAttached() {
        this.view.forceAttachedState(true);
        this.view.setPixelSize(10, 10);
        this.view.onResize();
        ((SimpleWorkbenchPanelPresenter)Mockito.verify((Object)this.presenter)).onResize(((Integer)Matchers.any(Integer.class)).intValue(), ((Integer)Matchers.any(Integer.class)).intValue());
        ((SimpleLayoutPanel)Mockito.verify((Object)this.topLevelWidget)).onResize();
    }

    @Test
    public void shouldNotPropagateResizeWhenNotAttached() {
        this.view.forceAttachedState(false);
        this.view.setPixelSize(10, 10);
        this.view.onResize();
        ((SimpleWorkbenchPanelPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).onResize(((Integer)Matchers.any(Integer.class)).intValue(), ((Integer)Matchers.any(Integer.class)).intValue());
        ((SimpleLayoutPanel)Mockito.verify((Object)this.topLevelWidget)).onResize();
    }

    @Test
    public void shouldDisableCloseParts() {
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).disableClosePart();
        ((ListBarWidget)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).enableClosePart();
    }

    @Test(expected=RuntimeException.class)
    public void shouldOnlyHaveOnePart() {
        Assert.assertEquals((long)0L, (long)this.listBar.getPartsSize());
        this.getViewToTest().addPart((WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addPart((WorkbenchPartPresenter.View)Matchers.any(WorkbenchPartPresenter.View.class));
        Assert.assertEquals((long)1L, (long)this.listBar.getPartsSize());
        this.getViewToTest().addPart((WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addPart((WorkbenchPartPresenter.View)Matchers.any(WorkbenchPartPresenter.View.class));
        Assert.assertEquals((long)1L, (long)this.listBar.getPartsSize());
    }
}

