/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractWorkbenchPanelPresenter;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

public abstract class AbstractDockingWorkbenchPanelPresenter<P extends AbstractWorkbenchPanelPresenter<P>>
extends AbstractWorkbenchPanelPresenter<P>
implements DockingWorkbenchPanelPresenter {
    @Inject
    private PanelManager panelManager;

    public AbstractDockingWorkbenchPanelPresenter(WorkbenchPanelView<P> view, PerspectiveManager perspectiveManager) {
        super(view, perspectiveManager);
    }

    @Override
    public void addPanel(WorkbenchPanelPresenter newChild, Position position) {
        WorkbenchPanelPresenter existingChild;
        DockingWorkbenchPanelPresenter dockingParent;
        if (this.getParent() instanceof DockingWorkbenchPanelPresenter && (dockingParent = (DockingWorkbenchPanelPresenter)this.getParent()).getPanels().get(position) == this) {
            dockingParent.setChildSize(this, Layouts.widthOrDefault(newChild.getDefinition()) + Layouts.widthOrDefault(this.getDefinition()), Layouts.heightOrDefault(newChild.getDefinition()) + Layouts.heightOrDefault(this.getDefinition()));
        }
        if ((existingChild = this.getPanels().get(position)) != null && newChild instanceof AbstractDockingWorkbenchPanelPresenter) {
            int existingChildSize = Layouts.widthOrHeight((CompassPosition)position, existingChild.getDefinition());
            int newChildSize = Layouts.widthOrHeight((CompassPosition)position, newChild.getDefinition());
            this.removePanel(existingChild);
            super.addPanel(newChild, position);
            newChild.addPanel(existingChild, position);
            this.getPanelView().setChildSize(newChild.getPanelView(), newChildSize + existingChildSize);
        } else {
            super.addPanel(newChild, position);
        }
    }

    @Override
    public boolean removePanel(WorkbenchPanelPresenter child) {
        if (child instanceof AbstractDockingWorkbenchPanelPresenter) {
            Position removedPosition = this.positionOf(child);
            if (removedPosition == null) {
                return false;
            }
            ArrayList<AbstractDockingWorkbenchPanelPresenter> rescuedOrphans = new ArrayList<AbstractDockingWorkbenchPanelPresenter>();
            AbstractDockingWorkbenchPanelPresenter dockingChild = (AbstractDockingWorkbenchPanelPresenter)child;
            for (Map.Entry<Position, WorkbenchPanelPresenter> entry : dockingChild.getPanels().entrySet()) {
                dockingChild.removeWithoutOrphanRescue(entry.getValue());
                rescuedOrphans.add((AbstractDockingWorkbenchPanelPresenter)entry.getValue());
            }
            super.removePanel(dockingChild);
            for (AbstractDockingWorkbenchPanelPresenter rescued : rescuedOrphans) {
                this.addPanel(rescued, removedPosition);
            }
            return true;
        }
        return super.removePanel(child);
    }

    private boolean removeWithoutOrphanRescue(WorkbenchPanelPresenter child) {
        return super.removePanel(child);
    }

    @Override
    public boolean setChildSize(WorkbenchPanelPresenter child, Integer pixelWidth, Integer pixelHeight) {
        for (Map.Entry<Position, WorkbenchPanelPresenter> e : this.getPanels().entrySet()) {
            int size;
            if (e.getValue() != child) continue;
            CompassPosition cp = CompassPosition.valueOf((String)("" + e.getKey()));
            if (cp == CompassPosition.NORTH || cp == CompassPosition.SOUTH) {
                if (pixelHeight == null) {
                    return false;
                }
                size = pixelHeight + this.nestedPanelHeights(child);
            } else if (cp == CompassPosition.EAST || cp == CompassPosition.WEST) {
                if (pixelWidth == null) {
                    return false;
                }
                size = pixelWidth + this.nestedPanelWidths(child);
            } else {
                throw new AssertionError((Object)("Unexpected child position: " + e.getKey()));
            }
            this.getPanelView().setChildSize(child.getPanelView(), size);
            return true;
        }
        return false;
    }

    private int nestedPanelHeights(WorkbenchPanelPresenter child) {
        WorkbenchPanelPresenter southChild;
        int totalHeight = 0;
        WorkbenchPanelPresenter northChild = child.getPanels().get(CompassPosition.NORTH);
        if (northChild != null) {
            totalHeight += northChild.getDefinition().getHeight().intValue();
            totalHeight += this.nestedPanelHeights(northChild);
        }
        if ((southChild = child.getPanels().get(CompassPosition.SOUTH)) != null) {
            totalHeight += southChild.getDefinition().getHeight().intValue();
            totalHeight += this.nestedPanelHeights(southChild);
        }
        return totalHeight;
    }

    private int nestedPanelWidths(WorkbenchPanelPresenter child) {
        WorkbenchPanelPresenter eastChild;
        int totalWidth = 0;
        WorkbenchPanelPresenter westChild = child.getPanels().get(CompassPosition.WEST);
        if (westChild != null) {
            totalWidth += westChild.getDefinition().getWidth().intValue();
            totalWidth += this.nestedPanelWidths(westChild);
        }
        if ((eastChild = child.getPanels().get(CompassPosition.EAST)) != null) {
            totalWidth += eastChild.getDefinition().getWidth().intValue();
            totalWidth += this.nestedPanelWidths(eastChild);
        }
        return totalWidth;
    }

    @Override
    public boolean removePart(PartDefinition part) {
        if (super.removePart(part)) {
            PanelDefinition panelDef = this.getDefinition();
            if (panelDef.getParts().isEmpty() && this.getParent() != null) {
                this.panelManager.removeWorkbenchPanel(this.getDefinition());
            }
            return true;
        }
        return false;
    }

    @Override
    public DockingWorkbenchPanelView<P> getPanelView() {
        return (DockingWorkbenchPanelView)super.getPanelView();
    }
}

