/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMenuBarPresenterTest {
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    protected User identity;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private WorkbenchMenuBarPresenter.View view;
    @InjectMocks
    private WorkbenchMenuBarPresenter presenter;

    @Test
    public void testAddCurrentPerspective() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("perspectiveId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).selectMenuItem("perspectiveId");
    }

    @Test
    public void testAddPerspective() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("anyId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).selectMenuItem("perspectiveId");
    }

    @Test
    public void testPerspectiveChangeEvent() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("perspectiveId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveChange perspectiveChange = new PerspectiveChange((PlaceRequest)placeRequest, null, null, "perspectiveId");
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)perspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        this.presenter.onPerspectiveChange(perspectiveChange);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).selectMenuItem("perspectiveId");
    }

    @Test
    public void testAddMenuWithPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addMenuItem((String)Matchers.eq((Object)"perspectiveId"), (String)Matchers.eq((Object)"perspectiveLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddMenuWithoutPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)false);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addMenuItem((String)Matchers.eq((Object)"perspectiveId"), (String)Matchers.eq((Object)"perspectiveLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenuWithPermission() {
        String perspectiveId = "perspectiveId";
        String contextLabel = "contextLabel";
        MenuPosition position = MenuPosition.LEFT;
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItem((String)Matchers.eq((Object)"perspectiveId"), Matchers.anyString(), (String)Matchers.eq((Object)"contextLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.eq((Object)position));
    }

    @Test
    public void testAddContextMenuWithoutPermission() {
        String perspectiveId = "perspectiveId";
        String contextLabel = "contextLabel";
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addContextMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testSetupEnableDisableMenuItemCommand() {
        String label = "command";
        Command command = (Command)Mockito.mock(Command.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"command").respondsWith(command)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPlace() {
        String label = "placeLabel";
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"placeLabel").place(place)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPerspective() {
        String label = "perspectiveLabel";
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableContextMenuItem() {
        String contextLabel = "contextLabel";
        String perspectiveId = "perspectiveId";
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testMenuInsertionOrder() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus firstMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Menus secondMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(1)).perspective("perspectiveId")).endMenu()).build();
        Menus thirdMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(2)).perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)firstMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)secondMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)thirdMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(thirdMenus);
        this.presenter.addMenus(firstMenus);
        this.presenter.addMenus(secondMenus);
        Assert.assertEquals((long)3L, (long)this.presenter.getAddedMenus().size());
        Assert.assertSame((Object)firstMenus, this.presenter.getAddedMenus().get(0));
        Assert.assertSame((Object)secondMenus, this.presenter.getAddedMenus().get(1));
        Assert.assertSame((Object)thirdMenus, this.presenter.getAddedMenus().get(2));
    }

    @Test
    public void testView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testCollapse() {
        this.presenter.collapse();
        Assert.assertFalse((boolean)this.presenter.isUseExpandedMode());
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).collapse();
    }

    @Test
    public void testExpand() {
        this.presenter.expand();
        Assert.assertTrue((boolean)this.presenter.isUseExpandedMode());
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).expand();
    }

    @Test
    public void testAddCollapseHandler() {
        Command command = (Command)Mockito.mock(Command.class);
        this.presenter.addCollapseHandler(command);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addCollapseHandler(command);
    }

    @Test
    public void testExpandHandler() {
        ((WorkbenchMenuBarPresenter.View)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Command)invocation.getArguments()[0]).execute();
                return null;
            }
        }).when((Object)this.view)).addExpandHandler((Command)Matchers.any(Command.class));
        this.presenter.setup();
        Assert.assertTrue((boolean)this.presenter.isExpanded());
    }

    @Test
    public void testCollapseHandler() {
        ((WorkbenchMenuBarPresenter.View)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Command)invocation.getArguments()[0]).execute();
                return null;
            }
        }).when((Object)this.view)).addCollapseHandler((Command)Matchers.any(Command.class));
        this.presenter.setup();
        Assert.assertFalse((boolean)this.presenter.isExpanded());
    }

    @Test
    public void testAddExpandHandler() {
        Command command = (Command)Mockito.mock(Command.class);
        this.presenter.addExpandHandler(command);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addExpandHandler(command);
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testOnPlaceMaximized() {
        this.presenter.onPlaceMaximized((PlaceMaximizedEvent)Mockito.mock(PlaceMaximizedEvent.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).collapse();
    }

    @Test
    public void testOnPlaceMinimized() {
        this.presenter.onPlaceMinimized((PlaceMinimizedEvent)Mockito.mock(PlaceMinimizedEvent.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).expand();
    }

    @Test
    public void testOnPlaceMinimizedExpandMode() {
        this.presenter.collapse();
        this.presenter.onPlaceMinimized((PlaceMinimizedEvent)Mockito.mock(PlaceMinimizedEvent.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).expand();
    }
}

