/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.IsSplashScreen;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.workbench.annotations.AssociatedResources;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.DotResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActivityBeansCacheActivatedByTest {
    private static final IsSplashScreen IS_SPLASH_SCREEN = new IsSplashScreen(){

        public Class<? extends Annotation> annotationType() {
            return IsSplashScreen.class;
        }
    };
    private static final AssociatedResources ASSOCIATED_RESOURCES = new AssociatedResources(){

        public Class<? extends Annotation> annotationType() {
            return AssociatedResources.class;
        }

        public Class<? extends ClientResourceType>[] value() {
            return new Class[]{DotResourceType.class};
        }
    };
    @InjectMocks
    ActivityBeansCache activityBeansCache;
    @Mock
    SyncBeanManager iocManager;
    private ActiveSplashScreenActivity activeSplashScreenActivity;
    private SyncBeanDef activeSplashScreenActivityBean;
    private SyncBeanDef nonActiveSplashScreenActivityBean;
    private ActiveRegularActivity activeRegularActivity;
    private SyncBeanDef activeRegularActivityBean;
    private SyncBeanDef nonActiveRegularActivityBean;
    private ActiveResourceActivity activeResourceActivity;
    private SyncBeanDef activeResourceActivityBean;
    private SyncBeanDef nonActiveResourceActivityBean;

    @Before
    public void setup() {
        this.activeSplashScreenActivity = (ActiveSplashScreenActivity)Mockito.mock(ActiveSplashScreenActivity.class);
        this.activeSplashScreenActivityBean = this.mockSplashScreenActivityBean(ActiveSplashScreenActivity.class, this.activeSplashScreenActivity);
        this.nonActiveSplashScreenActivityBean = this.mockSplashScreenActivityBean(NonActiveSplashScreenActivity.class, null);
        this.activeRegularActivity = (ActiveRegularActivity)Mockito.mock(ActiveRegularActivity.class);
        this.activeRegularActivityBean = this.mockRegularBean(ActiveRegularActivity.class, this.activeRegularActivity);
        this.nonActiveRegularActivityBean = this.mockRegularBean(NonActiveRegularActivity.class, null);
        this.activeResourceActivity = (ActiveResourceActivity)Mockito.mock(ActiveResourceActivity.class);
        this.activeResourceActivityBean = this.mockResourceActivityBean(ActiveResourceActivity.class, this.activeResourceActivity);
        this.mockRegularBean(DotResourceType.class, new DotResourceType());
        this.nonActiveResourceActivityBean = this.mockResourceActivityBean(NonActiveResourceActivity.class, null);
        ArrayList<SyncBeanDef> splashScreenBeans = new ArrayList<SyncBeanDef>();
        splashScreenBeans.add(this.activeSplashScreenActivityBean);
        splashScreenBeans.add(this.nonActiveSplashScreenActivityBean);
        ArrayList<SyncBeanDef> allActivityBeans = new ArrayList<SyncBeanDef>();
        allActivityBeans.add(this.activeSplashScreenActivityBean);
        allActivityBeans.add(this.nonActiveSplashScreenActivityBean);
        allActivityBeans.add(this.activeRegularActivityBean);
        allActivityBeans.add(this.nonActiveRegularActivityBean);
        allActivityBeans.add(this.activeResourceActivityBean);
        allActivityBeans.add(this.nonActiveResourceActivityBean);
        Mockito.when((Object)this.iocManager.lookupBeans(SplashScreenActivity.class)).thenReturn(splashScreenBeans);
        Mockito.when((Object)this.iocManager.lookupBeans(Activity.class)).thenReturn(allActivityBeans);
    }

    @Test
    public void shouldNotReturnInactiveBeansFromGetSplashScreens() throws Exception {
        this.activityBeansCache.init();
        List splashScreens = this.activityBeansCache.getSplashScreens();
        Assert.assertEquals((long)1L, (long)splashScreens.size());
        Assert.assertSame((Object)this.activeSplashScreenActivity, splashScreens.iterator().next());
    }

    @Test
    public void cacheShouldNotReturnInactiveBeansFromGetResourceActivities() throws Exception {
        this.activityBeansCache.init();
        List activityBeans = this.activityBeansCache.getResourceActivities();
        Assert.assertEquals((long)1L, (long)activityBeans.size());
        Assert.assertSame((Object)this.activeResourceActivityBean, (Object)((ActivityBeansCache.ActivityAndMetaInfo)activityBeans.get(0)).getActivityBean());
    }

    @Test
    public void cacheShouldNotReturnInactiveBeansByName() throws Exception {
        this.activityBeansCache.init();
        Assert.assertSame((Object)this.activeSplashScreenActivityBean, (Object)this.activityBeansCache.getActivity("ActiveSplashScreenActivity"));
        Assert.assertSame((Object)this.activeResourceActivityBean, (Object)this.activityBeansCache.getActivity("ActiveResourceActivity"));
        Assert.assertSame((Object)this.activeRegularActivityBean, (Object)this.activityBeansCache.getActivity("ActiveRegularActivity"));
        Assert.assertNull((Object)this.activityBeansCache.getActivity("NonActiveSplashScreenActivity"));
        Assert.assertNull((Object)this.activityBeansCache.getActivity("NonActiveResourceActivity"));
        Assert.assertNull((Object)this.activityBeansCache.getActivity("NonActiveRegularActivity"));
    }

    private <T> SyncBeanDef mockRegularBean(Class<T> type, T instance) {
        SyncBeanDef beanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)this.iocManager.lookupBeans(type.getName())).thenReturn(Collections.singleton(beanDef));
        Mockito.when((Object)beanDef.getInstance()).thenReturn(instance);
        Mockito.when((Object)beanDef.getBeanClass()).thenReturn(type);
        Mockito.when((Object)beanDef.isActivated()).thenReturn((Object)(instance != null ? 1 : 0));
        Mockito.when((Object)beanDef.getName()).thenReturn((Object)type.getSimpleName());
        return beanDef;
    }

    private <T extends SplashScreenActivity> SyncBeanDef mockSplashScreenActivityBean(Class<T> type, T instance) {
        SyncBeanDef beanDef = this.mockRegularBean(type, instance);
        Mockito.when((Object)beanDef.getQualifiers()).thenReturn(Collections.singleton(IS_SPLASH_SCREEN));
        return beanDef;
    }

    private <T extends Activity> SyncBeanDef mockResourceActivityBean(Class<T> type, T instance) {
        SyncBeanDef beanDef = this.mockRegularBean(type, instance);
        Mockito.when((Object)beanDef.getQualifiers()).thenReturn(Collections.singleton(ASSOCIATED_RESOURCES));
        return beanDef;
    }

    static interface NonActiveResourceActivity
    extends Activity {
    }

    static interface ActiveResourceActivity
    extends Activity {
    }

    static interface NonActiveRegularActivity
    extends Activity {
    }

    static interface ActiveRegularActivity
    extends Activity {
    }

    static interface NonActiveSplashScreenActivity
    extends SplashScreenActivity {
    }

    static interface ActiveSplashScreenActivity
    extends SplashScreenActivity {
    }
}

