/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.NewSplashScreenActiveEvent;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class SplashScreenMenuPresenter
implements IsWidget {
    private final PlaceManager placeManager;
    private final View view;

    protected SplashScreenMenuPresenter() {
        this.placeManager = null;
        this.view = null;
    }

    @Inject
    public SplashScreenMenuPresenter(PlaceManager placeManager, View view) {
        this.placeManager = (PlaceManager)PortablePreconditions.checkNotNull((String)"placeManager", (Object)placeManager);
        this.view = (View)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        view.init(this);
    }

    private void onNewSplashScreen(@Observes NewSplashScreenActiveEvent event) {
        ArrayList<SplashScreenListEntry> splashScreens = new ArrayList<SplashScreenListEntry>();
        for (final SplashScreenActivity activity : this.placeManager.getActiveSplashScreens()) {
            splashScreens.add(new SplashScreenListEntry(activity.getTitle(), new Command(){

                public void execute() {
                    activity.forceShow();
                }
            }));
        }
        this.view.setSplashScreenList(splashScreens);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public static class SplashScreenListEntry {
        private final String screenName;
        private final Command showCommand;

        public SplashScreenListEntry(String screenName, Command showCommand) {
            this.screenName = (String)PortablePreconditions.checkNotNull((String)"screenName", (Object)screenName);
            this.showCommand = (Command)PortablePreconditions.checkNotNull((String)"showCommand", (Object)showCommand);
        }

        public String getScreenName() {
            return this.screenName;
        }

        public Command getShowCommand() {
            return this.showCommand;
        }
    }

    public static interface View
    extends UberView<SplashScreenMenuPresenter> {
        public void setSplashScreenList(List<SplashScreenListEntry> var1);
    }
}

