/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

public abstract class AbstractWorkbenchEditorActivity
extends AbstractWorkbenchActivity
implements WorkbenchEditorActivity {
    @Inject
    protected Instance<LockManager> lockManagerProvider;
    protected LockManager lockManager;
    protected ObservablePath path;

    public AbstractWorkbenchEditorActivity(PlaceManager placeManager) {
        super(placeManager);
    }

    @Override
    public final void onStartup(PlaceRequest place) {
        Path path = place.getPath();
        if (path != null) {
            if (path instanceof ObservablePath) {
                this.onStartup((ObservablePath)path, place);
            } else if (this.isDynamic()) {
                this.onStartup(path, place);
            }
        } else {
            super.onStartup(place);
        }
    }

    void onStartup(Path path, PlaceRequest place) {
        this.onStartup(new PathPlaceRequest(path).getPath(), place);
    }

    @Override
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.onStartup(place);
        this.path = path;
        if (this.getLockingStrategy() == WorkbenchEditor.LockingStrategy.FRAMEWORK_PESSIMISTIC) {
            this.setupDefaultPessimisticLockManager();
        }
    }

    protected void setupDefaultPessimisticLockManager() {
        if (this.lockManager == null) {
            this.lockManager = (LockManager)this.lockManagerProvider.get();
            Runnable reloadRunnable = new Runnable(){

                @Override
                public void run() {
                    AbstractWorkbenchEditorActivity.this.onStartup(AbstractWorkbenchEditorActivity.this.path, AbstractWorkbenchEditorActivity.this.getPlace());
                }
            };
            LockTarget.TitleProvider titleProvider = new LockTarget.TitleProvider(){

                public String getTitle() {
                    AbstractWorkbenchEditorActivity activity = AbstractWorkbenchEditorActivity.this;
                    return activity.open ? activity.getTitle() : "";
                }
            };
            this.lockManager.init(new LockTarget((Path)this.path, this.getWidget(), this.getPlace(), titleProvider, reloadRunnable));
        }
    }

    @Override
    public void onOpen() {
        super.onOpen();
        if (this.assertFrameworkLockingStrategy()) {
            this.lockManager.acquireLockOnDemand();
        }
    }

    @Override
    public void onSave() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void onClose() {
        if (this.assertFrameworkLockingStrategy()) {
            this.lockManager.releaseLock();
            this.lockManagerProvider.destroy((Object)this.lockManager);
        }
        super.onClose();
    }

    @Override
    public void onFocus() {
        super.onFocus();
        if (this.path != null && this.assertFrameworkLockingStrategy()) {
            this.lockManager.onFocus();
        }
    }

    private boolean assertFrameworkLockingStrategy() {
        return this.getLockingStrategy() == WorkbenchEditor.LockingStrategy.FRAMEWORK_PESSIMISTIC && this.lockManager != null;
    }

    protected WorkbenchEditor.LockingStrategy getLockingStrategy() {
        return WorkbenchEditor.LockingStrategy.FRAMEWORK_PESSIMISTIC;
    }
}

