/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.authz;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.authz.ActivityCheck;
import org.uberfire.client.authz.PerspectiveCheck;
import org.uberfire.client.authz.WorkbenchController;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PopupActivity;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class DefaultWorkbenchController
implements WorkbenchController {
    AuthorizationManager authorizationManager;
    User user;

    @Inject
    public DefaultWorkbenchController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public static DefaultWorkbenchController get() {
        return (DefaultWorkbenchController)IOC.getBeanManager().lookupBean(DefaultWorkbenchController.class, new Annotation[0]).getInstance();
    }

    @Override
    public PerspectiveCheck perspectives() {
        return new PerspectiveCheck(this.authorizationManager, (ResourceType)ActivityResourceType.PERSPECTIVE, this.user);
    }

    @Override
    public ActivityCheck screens() {
        return new ActivityCheck(this.authorizationManager, (ResourceType)ActivityResourceType.SCREEN, this.user);
    }

    @Override
    public ActivityCheck popupScreens() {
        return new ActivityCheck(this.authorizationManager, (ResourceType)ActivityResourceType.POPUP, this.user);
    }

    @Override
    public ActivityCheck splashScreens() {
        return new ActivityCheck(this.authorizationManager, (ResourceType)ActivityResourceType.SPLASH, this.user);
    }

    @Override
    public ActivityCheck editors() {
        return new ActivityCheck(this.authorizationManager, (ResourceType)ActivityResourceType.EDITOR, this.user);
    }

    @Override
    public PerspectiveCheck perspective(PerspectiveActivity perspective) {
        return new PerspectiveCheck(this.authorizationManager, (Resource)perspective, this.user);
    }

    @Override
    public ActivityCheck screen(WorkbenchScreenActivity screen) {
        return new ActivityCheck(this.authorizationManager, (Resource)screen, this.user);
    }

    @Override
    public ActivityCheck popupScreen(PopupActivity popup) {
        return new ActivityCheck(this.authorizationManager, (Resource)popup, this.user);
    }

    @Override
    public ActivityCheck editor(WorkbenchEditorActivity editor) {
        return new ActivityCheck(this.authorizationManager, (Resource)editor, this.user);
    }

    @Override
    public ActivityCheck splashScreen(SplashScreenActivity splash) {
        return new ActivityCheck(this.authorizationManager, (Resource)splash, this.user);
    }

    @Override
    public PerspectiveCheck perspective(String perspectiveId) {
        ResourceRef ref = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return new PerspectiveCheck(this.authorizationManager, (Resource)ref, this.user);
    }

    @Override
    public ActivityCheck screen(String screenId) {
        ResourceRef ref = new ResourceRef(screenId, (ResourceType)ActivityResourceType.SCREEN);
        return new PerspectiveCheck(this.authorizationManager, (Resource)ref, this.user);
    }

    @Override
    public ActivityCheck popupScreen(String popupId) {
        ResourceRef ref = new ResourceRef(popupId, (ResourceType)ActivityResourceType.POPUP);
        return new PerspectiveCheck(this.authorizationManager, (Resource)ref, this.user);
    }

    @Override
    public ActivityCheck editor(String editorId) {
        ResourceRef ref = new ResourceRef(editorId, (ResourceType)ActivityResourceType.EDITOR);
        return new PerspectiveCheck(this.authorizationManager, (Resource)ref, this.user);
    }

    @Override
    public ActivityCheck splashScreen(String splashId) {
        ResourceRef ref = new ResourceRef(splashId, (ResourceType)ActivityResourceType.SPLASH);
        return new PerspectiveCheck(this.authorizationManager, (Resource)ref, this.user);
    }
}

