/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.client.mvp.LockDemandDetector;
import org.uberfire.client.mvp.LockManagerImpl;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.RenameInProgressEvent;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.VFSLockServiceProxy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class LockManagerTest {
    @Spy
    @InjectMocks
    private LockManagerImpl lockManager;
    @Mock
    private LockDemandDetector lockDemandDetector;
    @Mock
    private User user;
    @Mock
    private VFSLockServiceProxy lockService;
    @Mock
    private Path path;
    @Mock
    private EventSourceMock<NotificationEvent> lockNotification;
    @Mock
    private EventSourceMock<ChangeTitleWidgetEvent> changeTitleEvent;
    @Mock
    private EventSourceMock<UpdatedLockStatusEvent> updatedLockStatusEvent;
    @GwtMock
    private TextArea widget;
    @GwtMock
    private Event event;
    private LockTarget target;
    private int reloads = 0;

    @Before
    public void setup() throws Exception {
        this.mockTimer();
        GwtMockito.useProviderForType(WorkbenchResources.class, (FakeProvider)new FakeProvider<WorkbenchResources>(){

            public WorkbenchResources getFake(Class<?> type) {
                return null;
            }
        });
        Runnable reloadRunnable = new Runnable(){

            @Override
            public void run() {
                LockManagerTest.this.reloads++;
            }
        };
        LockTarget.TitleProvider titleProvider = new LockTarget.TitleProvider(){

            public String getTitle() {
                return "";
            }
        };
        this.target = new LockTarget(this.path, (IsWidget)this.widget, (PlaceRequest)new DefaultPlaceRequest("mockPlace"), titleProvider, reloadRunnable);
        this.lockManager.init(this.target);
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"directory/file.drl");
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"mockedUser");
        Mockito.when((Object)this.lockDemandDetector.isLockRequired((Event)Matchers.any(Event.class))).thenReturn((Object)true);
    }

    @Test
    public void updateLockInfoOnInit() {
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).retrieveLockInfo((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void acquireLockOnDemand() {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockDemand();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void acquireLockDoesNotHitServerIfLocked() {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockFailure();
        this.simulateLockDemand();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        this.simulateLockDemand();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void notifyLockFailure() throws Exception {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockFailure();
        this.simulateLockDemand();
        ((EventSourceMock)Mockito.verify(this.lockNotification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
    }

    @Test
    public void notifyLockError() throws Exception {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockError();
        this.simulateLockDemand();
        ((EventSourceMock)Mockito.verify(this.lockNotification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
    }

    @Test
    public void reloadOnLockFailure() throws Exception {
        this.lockManager.acquireLockOnDemand();
        Assert.assertEquals((long)0L, (long)this.reloads);
        this.simulateLockFailure();
        this.simulateLockDemand();
        Assert.assertEquals((long)1L, (long)this.reloads);
    }

    @Test
    public void updateTitleOnFocus() {
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(ChangeTitleWidgetEvent.class));
        this.lockManager.onFocus();
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void handleWindowReparenting() {
        this.lockManager.acquireLockOnDemand();
        ((LockDemandDetector)Mockito.verify((Object)this.lockDemandDetector, (VerificationMode)Mockito.times((int)1))).getLockDemandEventTypes();
        ArgumentCaptor handlerCaptor = ArgumentCaptor.forClass(AttachEvent.Handler.class);
        ((TextArea)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).addAttachHandler((AttachEvent.Handler)handlerCaptor.capture());
        ((AttachEvent.Handler)handlerCaptor.getValue()).onAttachOrDetach(new AttachEvent(true){});
        ((LockDemandDetector)Mockito.verify((Object)this.lockDemandDetector, (VerificationMode)Mockito.times((int)2))).getLockDemandEventTypes();
    }

    @Test
    public void releaseLockOnSave() {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockSuccess();
        this.simulateLockDemand();
        this.lockManager.onSaveInProgress(new SaveInProgressEvent(this.path));
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).releaseLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void releaseLockOnUpdate() {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockSuccess();
        this.simulateLockDemand();
        this.lockManager.onResourceUpdated(new ResourceUpdatedEvent(this.path, "", (SessionInfo)new SessionInfoImpl(this.user)));
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).releaseLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void reloadEditorOnUpdateFromDifferentUser() {
        this.lockManager.onResourceUpdated(new ResourceUpdatedEvent(this.path, "", (SessionInfo)new SessionInfoImpl(this.user)));
        Assert.assertEquals((long)0L, (long)this.reloads);
        this.lockManager.onResourceUpdated(new ResourceUpdatedEvent(this.path, "", (SessionInfo)new SessionInfoImpl((User)new UserImpl("differentUser"))));
        Assert.assertEquals((long)0L, (long)this.reloads);
    }

    @Test
    public void releaseOwnedLockOnly() {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockFailure();
        this.simulateLockDemand();
        this.lockManager.onResourceUpdated(new ResourceUpdatedEvent(this.path, "", (SessionInfo)new SessionInfoImpl(this.user)));
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.never())).releaseLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void requestAcquireLockOnDemandNoMoreThanOnce() {
        this.lockManager.acquireLockOnDemand();
        this.simulateLockNoResponse();
        this.simulateLockDemand();
        this.simulateLockDemand();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void acquireLock() {
        this.lockManager.acquireLock();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void requestAcquireLockNoMoreThanOnce() {
        this.simulateLockNoResponse();
        this.lockManager.acquireLock();
        this.lockManager.acquireLock();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void requestAcquireLockNoMoreThanOnceForSameUser() {
        this.simulateLockSuccess();
        this.lockManager.acquireLock();
        this.lockManager.acquireLock();
        ((VFSLockServiceProxy)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void acquireLockFiresChangeTitleEvent() {
        this.simulateLockSuccess();
        this.lockManager.acquireLock();
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ChangeTitleWidgetEvent.class));
        this.lockManager.acquireLock();
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void testUpdateLockInfoWhenLockInfoURIIsEqualToLockTargetURI() {
        LockInfo lockInfo = (LockInfo)Mockito.mock(LockInfo.class);
        Path path = (Path)Mockito.mock(Path.class);
        Runnable runnable1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runnable2 = (Runnable)Mockito.mock(Runnable.class);
        List runnables = (List)Mockito.spy(new ArrayList<Runnable>(Arrays.asList(runnable1, runnable2)));
        ((LockManagerImpl)Mockito.doReturn((Object)runnables).when((Object)this.lockManager)).getSyncCompleteRunnables();
        Mockito.when((Object)lockInfo.getFile()).thenReturn((Object)path);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"directory/file.drl");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"directory/file.drl");
        this.lockManager.updateLockInfo(lockInfo);
        Assert.assertEquals((Object)lockInfo, (Object)this.lockManager.getLockInfo());
        Assert.assertTrue((boolean)this.lockManager.isLockSyncComplete());
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager)).fireChangeTitleEvent();
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager)).fireUpdatedLockStatusEvent();
        ((Runnable)Mockito.verify((Object)runnable1)).run();
        ((Runnable)Mockito.verify((Object)runnable2)).run();
        ((List)Mockito.verify((Object)runnables)).clear();
    }

    @Test
    public void testUpdateLockInfoWhenLockInfoURIIsNotEqualToLockTargetURI() {
        LockInfo lockInfo = (LockInfo)Mockito.mock(LockInfo.class);
        Path path = (Path)Mockito.mock(Path.class);
        Runnable runnable1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runnable2 = (Runnable)Mockito.mock(Runnable.class);
        List runnables = (List)Mockito.spy(new ArrayList<Runnable>(Arrays.asList(runnable1, runnable2)));
        ((LockManagerImpl)Mockito.doReturn((Object)runnables).when((Object)this.lockManager)).getSyncCompleteRunnables();
        Mockito.when((Object)lockInfo.getFile()).thenReturn((Object)path);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"directory/file1.drl");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"directory/file2.drl");
        this.lockManager.updateLockInfo(lockInfo);
        Assert.assertNotEquals((Object)lockInfo, (Object)this.lockManager.getLockInfo());
        Assert.assertFalse((boolean)this.lockManager.isLockSyncComplete());
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).fireChangeTitleEvent();
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).fireUpdatedLockStatusEvent();
        ((Runnable)Mockito.verify((Object)runnable1, (VerificationMode)Mockito.never())).run();
        ((Runnable)Mockito.verify((Object)runnable2, (VerificationMode)Mockito.never())).run();
        ((List)Mockito.verify((Object)runnables, (VerificationMode)Mockito.never())).clear();
    }

    @Test
    public void testUpdateLockInfoWhenLockTargetIsNull() {
        LockInfo lockInfo = (LockInfo)Mockito.mock(LockInfo.class);
        Runnable runnable1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runnable2 = (Runnable)Mockito.mock(Runnable.class);
        List runnables = (List)Mockito.spy(new ArrayList<Runnable>(Arrays.asList(runnable1, runnable2)));
        ((LockManagerImpl)Mockito.doReturn((Object)runnables).when((Object)this.lockManager)).getSyncCompleteRunnables();
        ((LockManagerImpl)Mockito.doReturn(null).when((Object)this.lockManager)).getLockTarget();
        this.lockManager.updateLockInfo(lockInfo);
        Assert.assertNotEquals((Object)lockInfo, (Object)this.lockManager.getLockInfo());
        Assert.assertFalse((boolean)this.lockManager.isLockSyncComplete());
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).fireChangeTitleEvent();
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).fireUpdatedLockStatusEvent();
        ((Runnable)Mockito.verify((Object)runnable1, (VerificationMode)Mockito.never())).run();
        ((Runnable)Mockito.verify((Object)runnable2, (VerificationMode)Mockito.never())).run();
        ((List)Mockito.verify((Object)runnables, (VerificationMode)Mockito.never())).clear();
    }

    @Test
    public void testOnRenameInProgressWhenLockInfoPathIsEqualToLockTargetPath() {
        RenameInProgressEvent renameInProgressEvent = (RenameInProgressEvent)Mockito.mock(RenameInProgressEvent.class);
        Mockito.when((Object)renameInProgressEvent.getPath()).thenReturn((Object)this.path);
        this.lockManager.onRenameInProgress(renameInProgressEvent);
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager)).releaseLock();
    }

    @Test
    public void testOnRenameInProgressWhenLockInfoPathIsNotEqualToLockTargetPath() {
        RenameInProgressEvent renameInProgressEvent = (RenameInProgressEvent)Mockito.mock(RenameInProgressEvent.class);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)renameInProgressEvent.getPath()).thenReturn((Object)path);
        this.lockManager.onRenameInProgress(renameInProgressEvent);
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).releaseLock();
    }

    @Test
    public void testOnRenameInProgressWhenLockTargetIsNull() {
        RenameInProgressEvent renameInProgressEvent = (RenameInProgressEvent)Mockito.mock(RenameInProgressEvent.class);
        ((LockManagerImpl)Mockito.doReturn(null).when((Object)this.lockManager)).getLockTarget();
        this.lockManager.onRenameInProgress(renameInProgressEvent);
        ((LockManagerImpl)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).releaseLock();
    }

    private void simulateLockDemand() {
        EventListener listener = this.lockManager.acquireLockOnDemand((Element)this.widget.getElement());
        listener.onBrowserEvent(this.event);
    }

    private void simulateLockFailure() {
        ((VFSLockServiceProxy)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                LockInfo lockInfo = new LockInfo(true, "somebody", LockManagerTest.this.path);
                LockResult failed = LockResult.failed((LockInfo)lockInfo);
                ((ParameterizedCommand)args[1]).execute((Object)failed);
                return null;
            }
        }).when((Object)this.lockService)).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    private void simulateLockSuccess() {
        ((VFSLockServiceProxy)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                LockResult acquired = LockResult.acquired((Path)LockManagerTest.this.path, (String)LockManagerTest.this.user.getIdentifier());
                ((ParameterizedCommand)args[1]).execute((Object)acquired);
                return null;
            }
        }).when((Object)this.lockService)).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    private void simulateLockError() {
        ((VFSLockServiceProxy)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                LockResult acquired = LockResult.error();
                ((ParameterizedCommand)args[1]).execute((Object)acquired);
                return null;
            }
        }).when((Object)this.lockService)).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    private void simulateLockNoResponse() {
        ((VFSLockServiceProxy)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return null;
            }
        }).when((Object)this.lockService)).acquireLock((Path)Matchers.any(Path.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    private void mockTimer() throws Exception {
        Timer mockTimer = new Timer(){

            public void run() {
                LockManagerTest.this.target.getReloadRunnable().run();
            }

            public void schedule(int delayMillis) {
                this.run();
            }
        };
        Field reloadTimer = LockManagerImpl.class.getDeclaredField("reloadTimer");
        reloadTimer.setAccessible(true);
        reloadTimer.set(this.lockManager, mockTimer);
    }
}

