/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.SplitLayoutPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.commons.data.Pair;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

@Dependent
@Named(value="SplitLayoutPanelView")
public class SplitLayoutPanelView
implements WorkbenchPanelView<SplitLayoutPanelPresenter> {
    private final SplitLayoutPanel layout = new SplitLayoutPanel(2);
    private final LayoutPanel centerPanel = new LayoutPanel();
    private final LayoutPanel westPanel = new LayoutPanel();
    @Inject
    PlaceManager placeManager;
    private SplitLayoutPanelPresenter presenter;
    private Pair<PanelDefinition, Widget> activePanel;
    @Inject
    private LayoutSelection layoutSelection;

    public SplitLayoutPanelView() {
        this.layout.addWest((Widget)this.westPanel, 217.0);
        this.layout.add((Widget)this.centerPanel);
    }

    @Override
    public void addPanel(PanelDefinition panel, WorkbenchPanelView view, Position position) {
        if (CompassPosition.WEST.equals((Object)position)) {
            Widget widget = view.asWidget();
            widget.addStyleName("split-west");
            this.westPanel.add(widget);
        } else if (CompassPosition.CENTER.equals((Object)position)) {
            if (this.activePanel != null) {
                for (PartDefinition part : PluginUtil.ensureIterable((Set)((PanelDefinition)this.activePanel.getK1()).getParts())) {
                    this.placeManager.closePlace(part.getPlace());
                }
            }
            Widget widget = view.asWidget();
            widget.addStyleName("split-center");
            this.centerPanel.clear();
            this.centerPanel.add(widget);
            this.activePanel = new Pair((Object)panel, (Object)widget);
        } else {
            throw new IllegalArgumentException("Unsupported position directive: " + position);
        }
    }

    @Override
    public boolean removePanel(WorkbenchPanelView<?> child) {
        return this.westPanel.remove(child) || this.centerPanel.remove(child);
    }

    public Widget asWidget() {
        return this.layout;
    }

    public void init(SplitLayoutPanelPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public SplitLayoutPanelPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void addPart(WorkbenchPartPresenter.View view) {
        throw new IllegalArgumentException("Presenter doesn't manage parts!");
    }

    @Override
    public boolean removePart(PartDefinition part) {
        throw new IllegalArgumentException("Presenter doesn't manage parts!");
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        throw new IllegalArgumentException("Presenter doesn't manage parts!");
    }

    @Override
    public Collection<PartDefinition> getParts() {
        throw new IllegalArgumentException("Presenter doesn't manage parts!");
    }

    @Override
    public Widget getPartDropRegion() {
        return null;
    }

    @Override
    public void setFocus(boolean hasFocus) {
    }

    public void onResize() {
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
    }

    @Override
    public void setElementId(String elementId) {
        if (elementId == null) {
            this.asWidget().getElement().removeAttribute("id");
        } else {
            this.asWidget().getElement().setAttribute("id", elementId);
        }
    }

    @Override
    public void maximize() {
        this.layoutSelection.get().maximize(this.asWidget());
    }

    @Override
    public void unmaximize() {
        this.layoutSelection.get().unmaximize(this.asWidget());
    }
}

