/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.errai.ioc.client.container.DynamicAnnotation;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityMetaInfo;
import org.uberfire.client.workbench.annotations.AssociatedResources;
import org.uberfire.client.workbench.annotations.Priority;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.commons.data.Pair;

public class ActivityMetaInfoTest {
    @Test
    public void generateNotGenerateActivityMetaInfo() {
        IOCBeanDef beanDefinition = (IOCBeanDef)Mockito.mock(IOCBeanDef.class);
        Mockito.when((Object)beanDefinition.getQualifiers()).thenReturn(Collections.emptySet());
        Pair nullGenerated = ActivityMetaInfo.generate((IOCBeanDef)beanDefinition);
        Assert.assertNull((Object)nullGenerated);
    }

    @Test
    public void generateActivityMetaInfo() {
        IOCBeanDef beanDefinition = (IOCBeanDef)Mockito.mock(IOCBeanDef.class);
        Priority priority = (Priority)Mockito.mock(Priority.class);
        Integer priorityValue = 1;
        Mockito.when((Object)priority.value()).thenReturn((Object)priorityValue);
        HashSet<Object> qualifiers = new HashSet<Object>();
        AssociatedResources associatedResources = (AssociatedResources)Mockito.mock(AssociatedResources.class);
        ArrayList<Class<ClientResourceType>> typesList = new ArrayList<Class<ClientResourceType>>();
        typesList.add(ClientResourceType.class);
        Class[] array = typesList.toArray(new Class[typesList.size()]);
        Mockito.when((Object)associatedResources.value()).thenReturn((Object)array);
        qualifiers.add(associatedResources);
        qualifiers.add(priority);
        Mockito.when((Object)beanDefinition.getQualifiers()).thenReturn(qualifiers);
        Pair generated = ActivityMetaInfo.generate((IOCBeanDef)beanDefinition);
        Assert.assertEquals((Object)priorityValue, (Object)generated.getK1());
        Assert.assertTrue((boolean)((List)generated.getK2()).contains(ClientResourceType.class.getName()));
    }

    @Test
    public void generateActivityMetaInfoForDynamicActivity() {
        String otherResourceType = "org.uberfire.OtherResourceType";
        IOCBeanDef beanDefinition = (IOCBeanDef)Mockito.mock(IOCBeanDef.class);
        DynamicAnnotation priority = (DynamicAnnotation)Mockito.mock(DynamicAnnotation.class);
        Mockito.when((Object)priority.getName()).thenReturn((Object)Priority.class.getName());
        Mockito.when((Object)priority.getMember("value")).thenReturn((Object)"1");
        HashSet<DynamicAnnotation> qualifiers = new HashSet<DynamicAnnotation>();
        DynamicAnnotation associatedResources = (DynamicAnnotation)Mockito.mock(DynamicAnnotation.class);
        Mockito.when((Object)associatedResources.getName()).thenReturn((Object)AssociatedResources.class.getName());
        Mockito.when((Object)associatedResources.getMember("value")).thenReturn((Object)("[" + ClientResourceType.class.getName() + "," + "org.uberfire.OtherResourceType" + "]"));
        qualifiers.add(associatedResources);
        qualifiers.add(priority);
        Mockito.when((Object)beanDefinition.isDynamic()).thenReturn((Object)true);
        Mockito.when((Object)beanDefinition.getQualifiers()).thenReturn(qualifiers);
        Pair generated = ActivityMetaInfo.generate((IOCBeanDef)beanDefinition);
        Assert.assertEquals((Object)1, (Object)generated.getK1());
        Assert.assertTrue((boolean)((List)generated.getK2()).contains(ClientResourceType.class.getName()));
        Assert.assertTrue((boolean)((List)generated.getK2()).contains("org.uberfire.OtherResourceType"));
    }
}

